/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.jdbc.common.tests;

import io.eventuate.EntityIdAndType;
import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.common.jdbc.EventuateSchema;
import io.eventuate.javaclient.commonimpl.common.EventTypeAndData;
import io.eventuate.javaclient.commonimpl.crud.AggregateCrudUpdateOptions;
import io.eventuate.javaclient.commonimpl.crud.LoadedEvents;
import io.eventuate.javaclient.commonimpl.crud.SerializedSnapshot;
import io.eventuate.javaclient.jdbc.EventuateJdbcAccess;
import io.eventuate.javaclient.jdbc.SaveUpdateResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.Assert;

public abstract class CommonEventuateJdbcAccessImplTest {
    private static final String testAggregate = "testAggregate1";
    private static final String testEventType = "testEventType1";
    private static final String testEventData = "testEventData1";

    protected abstract EventuateJdbcStatementExecutor getEventuateJdbcStatementExecutor();

    protected abstract EventuateJdbcAccess getEventuateJdbcAccess();

    protected abstract String readAllEventsSql();

    protected abstract String readAllEntitiesSql();

    protected abstract String readAllSnapshots();

    protected abstract EventuateSchema getEventuateSchema();

    protected void clear() {
        this.truncateTable("events");
        this.truncateTable("entities");
        this.truncateTable("snapshots");
    }

    private void truncateTable(String table) {
        this.getEventuateJdbcStatementExecutor().update(String.format("TRUNCATE TABLE %s", this.getEventuateSchema().qualifyTable(table)), new Object[0]);
    }

    public void testSave() {
        EventTypeAndData eventTypeAndData = new EventTypeAndData(testEventType, testEventData, Optional.empty());
        this.getEventuateJdbcAccess().save(testAggregate, Collections.singletonList(eventTypeAndData), Optional.empty());
        List events = this.getEventuateJdbcStatementExecutor().queryForList(this.readAllEventsSql(), new Object[0]);
        Assert.assertEquals((long)1L, (long)events.size());
        List entities = this.getEventuateJdbcStatementExecutor().queryForList(this.readAllEntitiesSql(), new Object[0]);
        Assert.assertEquals((long)1L, (long)entities.size());
    }

    public void testFind() {
        EventTypeAndData eventTypeAndData = new EventTypeAndData(testEventType, testEventData, Optional.empty());
        SaveUpdateResult saveUpdateResult = this.getEventuateJdbcAccess().save(testAggregate, Collections.singletonList(eventTypeAndData), Optional.empty());
        LoadedEvents loadedEvents = this.getEventuateJdbcAccess().find(testAggregate, saveUpdateResult.getEntityIdVersionAndEventIds().getEntityId(), Optional.empty());
        Assert.assertEquals((long)1L, (long)loadedEvents.getEvents().size());
    }

    public void testUpdate() {
        EventTypeAndData eventTypeAndData = new EventTypeAndData(testEventType, testEventData, Optional.empty());
        SaveUpdateResult saveUpdateResult = this.getEventuateJdbcAccess().save(testAggregate, Collections.singletonList(eventTypeAndData), Optional.empty());
        EntityIdAndType entityIdAndType = new EntityIdAndType(saveUpdateResult.getEntityIdVersionAndEventIds().getEntityId(), testAggregate);
        eventTypeAndData = new EventTypeAndData("testEventType2", "testEventData2", Optional.empty());
        this.getEventuateJdbcAccess().update(entityIdAndType, saveUpdateResult.getEntityIdVersionAndEventIds().getEntityVersion(), Collections.singletonList(eventTypeAndData), Optional.of(new AggregateCrudUpdateOptions(Optional.empty(), Optional.of(new SerializedSnapshot("", "")))));
        List events = this.getEventuateJdbcStatementExecutor().queryForList(this.readAllEventsSql(), new Object[0]);
        Assert.assertEquals((long)2L, (long)events.size());
        List entities = this.getEventuateJdbcStatementExecutor().queryForList(this.readAllEntitiesSql(), new Object[0]);
        Assert.assertEquals((long)1L, (long)entities.size());
        List snapshots = this.getEventuateJdbcStatementExecutor().queryForList(this.readAllSnapshots(), new Object[0]);
        Assert.assertEquals((long)1L, (long)snapshots.size());
        LoadedEvents loadedEvents = this.getEventuateJdbcAccess().find(testAggregate, saveUpdateResult.getEntityIdVersionAndEventIds().getEntityId(), Optional.empty());
        Assert.assertTrue((boolean)loadedEvents.getSnapshot().isPresent());
    }

    protected List<String> loadSqlScriptAsListOfLines(String script) {
        List<String> list;
        script = this.wrapClasspathResource(script);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(script)));
        try {
            list = bufferedReader.lines().collect(Collectors.toList());
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        bufferedReader.close();
        return list;
    }

    protected void executeSql(List<String> sqlList) {
        this.getEventuateJdbcStatementExecutor().update(sqlList.stream().collect(Collectors.joining("\n")), new Object[0]);
    }

    private String wrapClasspathResource(String file) {
        if (file.startsWith("/")) {
            return file;
        }
        return "/" + file;
    }
}

