/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.jdbc;

import io.eventuate.Aggregate;
import io.eventuate.DuplicateTriggeringEventException;
import io.eventuate.EntityAlreadyExistsException;
import io.eventuate.EntityIdAndType;
import io.eventuate.EntityNotFoundException;
import io.eventuate.EventContext;
import io.eventuate.OptimisticLockingException;
import io.eventuate.common.id.ApplicationIdGenerator;
import io.eventuate.common.id.IdGenerator;
import io.eventuate.common.id.Int128;
import io.eventuate.common.jdbc.EventuateCommonJdbcOperations;
import io.eventuate.common.jdbc.EventuateDuplicateKeyException;
import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.common.jdbc.EventuateRowMapper;
import io.eventuate.common.jdbc.EventuateSchema;
import io.eventuate.common.jdbc.EventuateTransactionTemplate;
import io.eventuate.common.jdbc.sqldialect.EventuateSqlDialect;
import io.eventuate.javaclient.commonimpl.common.EventIdTypeAndData;
import io.eventuate.javaclient.commonimpl.common.EventTypeAndData;
import io.eventuate.javaclient.commonimpl.crud.AggregateCrudFindOptions;
import io.eventuate.javaclient.commonimpl.crud.AggregateCrudSaveOptions;
import io.eventuate.javaclient.commonimpl.crud.AggregateCrudUpdateOptions;
import io.eventuate.javaclient.commonimpl.crud.EntityIdVersionAndEventIds;
import io.eventuate.javaclient.commonimpl.crud.LoadedEvents;
import io.eventuate.javaclient.commonimpl.crud.SerializedSnapshot;
import io.eventuate.javaclient.commonimpl.crud.SerializedSnapshotWithVersion;
import io.eventuate.javaclient.jdbc.EventAndTrigger;
import io.eventuate.javaclient.jdbc.EventuateJdbcAccess;
import io.eventuate.javaclient.jdbc.LoadedSnapshot;
import io.eventuate.javaclient.jdbc.PublishableEvents;
import io.eventuate.javaclient.jdbc.SaveUpdateResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventuateJdbcAccessImpl
implements EventuateJdbcAccess {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private IdGenerator idGenerator;
    private ApplicationIdGenerator applicationIdGenerator = new ApplicationIdGenerator();
    private EventuateTransactionTemplate eventuateTransactionTemplate;
    private EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor;
    private String entityTable;
    private String eventTable;
    private String snapshotTable;
    private EventuateCommonJdbcOperations eventuateCommonJdbcOperations;
    private EventuateSqlDialect eventuateSqlDialect;
    private EventuateSchema eventuateSchema;
    private final EventuateRowMapper<EventAndTrigger> eventAndTriggerRowMapper = (rs, rowNum) -> {
        String eventId = this.idGenerator.databaseIdRequired() ? this.idGenerator.genId(Long.valueOf(rs.getLong("id"))).asString() : rs.getString("event_id");
        String eventType = rs.getString("event_type");
        String eventData = rs.getString("event_data");
        String triggeringEvent = rs.getString("triggering_event");
        Optional<String> metadata = Optional.ofNullable(rs.getString("metadata"));
        return new EventAndTrigger(new EventIdTypeAndData(Int128.fromString((String)eventId), eventType, eventData, metadata), triggeringEvent);
    };

    public EventuateJdbcAccessImpl(IdGenerator idGenerator, EventuateTransactionTemplate eventuateTransactionTemplate, EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor, EventuateCommonJdbcOperations eventuateCommonJdbcOperations, EventuateSqlDialect eventuateSqlDialect) {
        this(idGenerator, eventuateTransactionTemplate, eventuateJdbcStatementExecutor, eventuateCommonJdbcOperations, eventuateSqlDialect, new EventuateSchema());
    }

    public EventuateJdbcAccessImpl(IdGenerator idGenerator, EventuateTransactionTemplate eventuateTransactionTemplate, EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor, EventuateCommonJdbcOperations eventuateCommonJdbcOperations, EventuateSqlDialect eventuateSqlDialect, EventuateSchema eventuateSchema) {
        this.idGenerator = idGenerator;
        this.eventuateTransactionTemplate = eventuateTransactionTemplate;
        this.eventuateJdbcStatementExecutor = eventuateJdbcStatementExecutor;
        this.eventuateCommonJdbcOperations = eventuateCommonJdbcOperations;
        this.eventuateSqlDialect = eventuateSqlDialect;
        this.eventuateSchema = eventuateSchema;
        this.entityTable = eventuateSchema.qualifyTable("entities");
        this.eventTable = eventuateSchema.qualifyTable("events");
        this.snapshotTable = eventuateSchema.qualifyTable("snapshots");
    }

    @Override
    public SaveUpdateResult save(String aggregateType, List<EventTypeAndData> events, Optional<AggregateCrudSaveOptions> saveOptions) {
        return (SaveUpdateResult)this.eventuateTransactionTemplate.executeInTransaction(() -> this.saveWithoutTransaction(aggregateType, events, saveOptions));
    }

    private SaveUpdateResult saveWithoutTransaction(String aggregateType, List<EventTypeAndData> events, Optional<AggregateCrudSaveOptions> saveOptions) {
        String entityId = saveOptions.flatMap(AggregateCrudSaveOptions::getEntityId).orElse(this.applicationIdGenerator.genId(null).asString());
        ArrayList<EventIdTypeAndData> eventsWithIds = new ArrayList<EventIdTypeAndData>();
        for (EventTypeAndData event : events) {
            String eventId = this.eventuateCommonJdbcOperations.insertIntoEventsTable(this.idGenerator, entityId, event.getEventData(), event.getEventType(), aggregateType, saveOptions.flatMap(AggregateCrudSaveOptions::getTriggeringEvent).map(EventContext::getEventToken), event.getMetadata(), this.eventuateSchema);
            eventsWithIds.add(new EventIdTypeAndData(Int128.fromString((String)eventId), event.getEventType(), event.getEventData(), event.getMetadata()));
        }
        Int128 entityVersion = ((EventIdTypeAndData)this.last(eventsWithIds)).getId();
        try {
            this.eventuateJdbcStatementExecutor.update(String.format("INSERT INTO %s (entity_type, entity_id, entity_version) VALUES (?, ?, ?)", this.entityTable), new Object[]{aggregateType, entityId, entityVersion.asString()});
        }
        catch (EventuateDuplicateKeyException e) {
            throw new EntityAlreadyExistsException();
        }
        List eventIds = eventsWithIds.stream().map(EventIdTypeAndData::getId).collect(Collectors.toList());
        return new SaveUpdateResult(new EntityIdVersionAndEventIds(entityId, entityVersion, eventIds), new PublishableEvents(aggregateType, entityId, eventsWithIds));
    }

    private <T> T last(List<T> eventsWithIds) {
        return eventsWithIds.get(eventsWithIds.size() - 1);
    }

    @Override
    public <T extends Aggregate<T>> LoadedEvents find(String aggregateType, String entityId, Optional<AggregateCrudFindOptions> findOptions) {
        return (LoadedEvents)this.eventuateTransactionTemplate.executeInTransaction(() -> this.findWithoutTransaction(aggregateType, entityId, findOptions));
    }

    private <T extends Aggregate<T>> LoadedEvents findWithoutTransaction(String aggregateType, String entityId, Optional<AggregateCrudFindOptions> findOptions) {
        String query = String.format("select snapshot_type, snapshot_json, entity_version, triggering_Events from %s where entity_type = ? and entity_id = ? order by entity_version desc", this.snapshotTable);
        query = this.eventuateSqlDialect.addLimitToSql(query, "1");
        Optional snapshot = this.eventuateJdbcStatementExecutor.query(query, (rs, rownum) -> new LoadedSnapshot(new SerializedSnapshotWithVersion(new SerializedSnapshot(rs.getString("snapshot_type"), rs.getString("snapshot_json")), Int128.fromString((String)rs.getString("entity_version"))), rs.getString("triggering_events")), new Object[]{aggregateType, entityId}).stream().findFirst();
        List events = snapshot.isPresent() ? this.eventuateJdbcStatementExecutor.query(String.format("SELECT * FROM %s where entity_type = ? and entity_id = ? and event_id > ? order by event_id asc", this.eventTable), this.eventAndTriggerRowMapper, new Object[]{aggregateType, entityId, ((LoadedSnapshot)snapshot.get()).getSerializedSnapshot().getEntityVersion().asString()}) : this.eventuateJdbcStatementExecutor.query(String.format("SELECT * FROM %s where entity_type = ? and entity_id = ? order by event_id asc", this.eventTable), this.eventAndTriggerRowMapper, new Object[]{aggregateType, entityId});
        this.logger.debug("Loaded {} events", (Object)events);
        Optional matching = findOptions.flatMap(AggregateCrudFindOptions::getTriggeringEvent).flatMap(te -> events.stream().filter(e -> te.getEventToken().equals(e.triggeringEvent)).findAny());
        if (matching.isPresent()) {
            throw new DuplicateTriggeringEventException();
        }
        if (!snapshot.isPresent() && events.isEmpty()) {
            throw new EntityNotFoundException(aggregateType, entityId);
        }
        return new LoadedEvents(snapshot.map(LoadedSnapshot::getSerializedSnapshot), events.stream().map(e -> e.event).collect(Collectors.toList()));
    }

    @Override
    public SaveUpdateResult update(EntityIdAndType entityIdAndType, Int128 entityVersion, List<EventTypeAndData> events, Optional<AggregateCrudUpdateOptions> updateOptions) {
        return (SaveUpdateResult)this.eventuateTransactionTemplate.executeInTransaction(() -> this.updateWithoutTransaction(entityIdAndType, entityVersion, events, updateOptions));
    }

    @Override
    public SaveUpdateResult update(EntityIdAndType entityIdAndType, List<EventTypeAndData> events, Optional<AggregateCrudUpdateOptions> updateOptions) {
        return (SaveUpdateResult)this.eventuateTransactionTemplate.executeInTransaction(() -> this.updateWithoutTransaction(entityIdAndType, events, updateOptions));
    }

    public SaveUpdateResult updateWithoutTransaction(EntityIdAndType entityIdAndType, Int128 entityVersion, List<EventTypeAndData> events, Optional<AggregateCrudUpdateOptions> updateOptions) {
        String entityType = entityIdAndType.getEntityType();
        String aggregateType = entityIdAndType.getEntityType();
        String entityId = entityIdAndType.getEntityId();
        Optional<String> eventToken = updateOptions.flatMap(AggregateCrudUpdateOptions::getTriggeringEvent).map(EventContext::getEventToken);
        List<EventIdTypeAndData> eventsWithIds = this.insertEvents(events, entityId, entityType, eventToken);
        Int128 updatedEntityVersion = this.last(eventsWithIds).getId();
        int count = this.eventuateJdbcStatementExecutor.update(String.format("UPDATE %s SET entity_version = ? WHERE entity_type = ? and entity_id = ? and entity_version = ?", this.entityTable), new Object[]{updatedEntityVersion.asString(), entityType, entityId, entityVersion.asString()});
        if (count != 1) {
            this.logger.error("Failed to update entity: {}", (Object)count);
            throw new OptimisticLockingException(entityIdAndType, entityVersion);
        }
        updateOptions.flatMap(AggregateCrudUpdateOptions::getSnapshot).ifPresent(ss -> {
            String query = String.format("select snapshot_type, snapshot_json, entity_version, triggering_Events from %s where entity_type = ? and entity_id = ? order by entity_version desc", this.snapshotTable);
            query = this.eventuateSqlDialect.addLimitToSql(query, "1");
            Optional<LoadedSnapshot> previousSnapshot = this.eventuateJdbcStatementExecutor.query(query, (rs, rownum) -> new LoadedSnapshot(new SerializedSnapshotWithVersion(new SerializedSnapshot(rs.getString("snapshot_type"), rs.getString("snapshot_json")), Int128.fromString((String)rs.getString("entity_version"))), rs.getString("triggering_events")), new Object[]{aggregateType, entityId}).stream().findFirst();
            List oldEvents = previousSnapshot.isPresent() ? this.eventuateJdbcStatementExecutor.query(String.format("SELECT * FROM %s where entity_type = ? and entity_id = ? and event_id > ? order by event_id asc", this.eventTable), this.eventAndTriggerRowMapper, new Object[]{aggregateType, entityId, ((LoadedSnapshot)previousSnapshot.get()).getSerializedSnapshot().getEntityVersion().asString()}) : this.eventuateJdbcStatementExecutor.query(String.format("SELECT * FROM %s where entity_type = ? and entity_id = ? order by event_id asc", this.eventTable), this.eventAndTriggerRowMapper, new Object[]{aggregateType, entityId});
            String triggeringEvents = this.snapshotTriggeringEvents(previousSnapshot, oldEvents, updateOptions.flatMap(AggregateCrudUpdateOptions::getTriggeringEvent));
            this.eventuateJdbcStatementExecutor.update(String.format("INSERT INTO %s (entity_type, entity_id, entity_version, snapshot_type, snapshot_json, triggering_events) VALUES (?, ?, ?, ?, ?, ?)", this.snapshotTable), new Object[]{entityType, entityId, updatedEntityVersion.asString(), ss.getSnapshotType(), ss.getJson(), triggeringEvents});
        });
        return new SaveUpdateResult(new EntityIdVersionAndEventIds(entityId, updatedEntityVersion, eventsWithIds.stream().map(EventIdTypeAndData::getId).collect(Collectors.toList())), new PublishableEvents(aggregateType, entityId, eventsWithIds));
    }

    public SaveUpdateResult updateWithoutTransaction(EntityIdAndType entityIdAndType, List<EventTypeAndData> events, Optional<AggregateCrudUpdateOptions> updateOptions) {
        String entityType = entityIdAndType.getEntityType();
        String aggregateType = entityIdAndType.getEntityType();
        String entityId = entityIdAndType.getEntityId();
        Optional<String> eventToken = updateOptions.flatMap(AggregateCrudUpdateOptions::getTriggeringEvent).map(EventContext::getEventToken);
        List<EventIdTypeAndData> eventsWithIds = this.insertEvents(events, entityId, entityType, eventToken);
        Int128 updatedEntityVersion = this.last(eventsWithIds).getId();
        this.eventuateJdbcStatementExecutor.update(String.format("UPDATE %s SET entity_version = ? WHERE entity_type = ? and entity_id = ?", this.entityTable), new Object[]{updatedEntityVersion.asString(), entityType, entityId});
        return new SaveUpdateResult(new EntityIdVersionAndEventIds(entityId, updatedEntityVersion, eventsWithIds.stream().map(EventIdTypeAndData::getId).collect(Collectors.toList())), new PublishableEvents(aggregateType, entityId, eventsWithIds));
    }

    protected void checkSnapshotForDuplicateEvent(LoadedSnapshot ss, EventContext te) {
    }

    protected String snapshotTriggeringEvents(Optional<LoadedSnapshot> previousSnapshot, List<EventAndTrigger> events, Optional<EventContext> eventContext) {
        return null;
    }

    private List<EventIdTypeAndData> insertEvents(List<EventTypeAndData> events, String entityId, String entityType, Optional<String> eventToken) {
        ArrayList<EventIdTypeAndData> eventsWithIds = new ArrayList<EventIdTypeAndData>();
        for (EventTypeAndData event : events) {
            String eventId = this.eventuateCommonJdbcOperations.insertIntoEventsTable(this.idGenerator, entityId, event.getEventData(), event.getEventType(), entityType, eventToken, event.getMetadata(), this.eventuateSchema);
            eventsWithIds.add(new EventIdTypeAndData(Int128.fromString((String)eventId), event.getEventType(), event.getEventData(), event.getMetadata()));
        }
        return eventsWithIds;
    }
}

