/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.javaclient.jdbc;

import io.eventuate.EventContext;
import io.eventuate.SubscriberOptions;
import io.eventuate.javaclient.commonimpl.common.EventIdTypeAndData;
import io.eventuate.javaclient.commonimpl.common.SerializedEvent;
import io.eventuate.javaclient.commonimpl.events.sync.AggregateEvents;
import io.eventuate.javaclient.jdbc.AbstractJdbcAggregateCrud;
import io.eventuate.javaclient.jdbc.EventuateJdbcAccess;
import io.eventuate.javaclient.jdbc.PublishableEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

public class EventuateEmbeddedTestAggregateStore
extends AbstractJdbcAggregateCrud
implements AggregateEvents {
    private final AtomicLong eventOffset = new AtomicLong();
    private final Map<String, List<Subscription>> aggregateTypeToSubscription = new HashMap<String, List<Subscription>>();

    public EventuateEmbeddedTestAggregateStore(EventuateJdbcAccess eventuateJdbcAccess) {
        super(eventuateJdbcAccess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void publish(PublishableEvents publishableEvents) {
        ArrayList<Subscription> subscriptions;
        String aggregateType = publishableEvents.getAggregateType();
        String aggregateId = publishableEvents.getEntityId();
        List eventsWithIds = publishableEvents.getEventsWithIds();
        Map<String, List<Subscription>> map = this.aggregateTypeToSubscription;
        synchronized (map) {
            List<Subscription> x = this.aggregateTypeToSubscription.get(aggregateType);
            subscriptions = x == null ? null : new ArrayList<Subscription>(x);
        }
        if (subscriptions != null) {
            for (Subscription subscription : subscriptions) {
                for (EventIdTypeAndData event : eventsWithIds) {
                    if (!subscription.isInterestedIn(aggregateType, event.getEventType())) continue;
                    subscription.handler.apply(new SerializedEvent(event.getId(), aggregateId, aggregateType, event.getEventData(), event.getEventType(), Integer.valueOf(aggregateId.hashCode() % 8), Long.valueOf(this.eventOffset.getAndIncrement()), new EventContext(event.getId().asString()), event.getMetadata()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribe(String subscriberId, Map<String, Set<String>> aggregatesAndEvents, SubscriberOptions options, Function<SerializedEvent, CompletableFuture<?>> handler) {
        Subscription subscription = new Subscription(subscriberId, aggregatesAndEvents, handler);
        Map<String, List<Subscription>> map = this.aggregateTypeToSubscription;
        synchronized (map) {
            for (String aggregateType : aggregatesAndEvents.keySet()) {
                List<Subscription> existing = this.aggregateTypeToSubscription.get(aggregateType);
                if (existing == null) {
                    existing = new LinkedList<Subscription>();
                    this.aggregateTypeToSubscription.put(aggregateType, existing);
                }
                existing.add(subscription);
            }
        }
    }

    class Subscription {
        private final String subscriberId;
        private final Map<String, Set<String>> aggregatesAndEvents;
        private final Function<SerializedEvent, CompletableFuture<?>> handler;

        public Subscription(String subscriberId, Map<String, Set<String>> aggregatesAndEvents, Function<SerializedEvent, CompletableFuture<?>> handler) {
            this.subscriberId = subscriberId;
            this.aggregatesAndEvents = aggregatesAndEvents;
            this.handler = handler;
        }

        public boolean isInterestedIn(String aggregateType, String eventType) {
            return this.aggregatesAndEvents.get(aggregateType) != null && this.aggregatesAndEvents.get(aggregateType).contains(eventType);
        }
    }
}

