/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate;

import io.eventuate.Aggregate;
import io.eventuate.Aggregates;
import io.eventuate.Command;
import io.eventuate.CommandOutcome;
import io.eventuate.CommandProcessingAggregate;
import io.eventuate.CommonAggregateRepository;
import io.eventuate.CompletableFutureUtil;
import io.eventuate.DuplicateTriggeringEventException;
import io.eventuate.EntityIdAndVersion;
import io.eventuate.EntityWithIdAndVersion;
import io.eventuate.EntityWithMetadata;
import io.eventuate.Event;
import io.eventuate.EventWithMetadata;
import io.eventuate.EventuateAggregateStoreCrud;
import io.eventuate.EventuateCommandProcessingFailedException;
import io.eventuate.FindOptions;
import io.eventuate.OptimisticLockingException;
import io.eventuate.SaveOptions;
import io.eventuate.Snapshot;
import io.eventuate.UpdateEventsAndOptions;
import io.eventuate.UpdateOptions;
import io.eventuate.common.id.Int128;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateRepository<T extends CommandProcessingAggregate<T, CT>, CT extends Command>
extends CommonAggregateRepository<T, CT> {
    private static Logger logger = LoggerFactory.getLogger(AggregateRepository.class);
    private EventuateAggregateStoreCrud aggregateStore;

    public AggregateRepository(Class<T> clasz, EventuateAggregateStoreCrud aggregateStore) {
        super(clasz);
        this.aggregateStore = aggregateStore;
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> save(CT cmd) {
        return this.save(cmd, Optional.empty());
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> save(CT cmd, Optional<SaveOptions> saveOptions) {
        CommandProcessingAggregate aggregate;
        try {
            aggregate = (CommandProcessingAggregate)this.clasz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        List<Event> events = aggregate.processCommand(cmd);
        Aggregates.applyEventsToMutableAggregate(aggregate, events, this.missingApplyEventMethodStrategy);
        return this.aggregateStore.save(this.clasz, events, saveOptions).thenApply(entityIdAndVersion -> new EntityWithIdAndVersion<CommandProcessingAggregate>((EntityIdAndVersion)entityIdAndVersion, aggregate));
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> update(String entityId, CT cmd) {
        return this.update(entityId, cmd, Optional.empty());
    }

    private <T> CompletableFuture<T> withRetry(Supplier<CompletableFuture<T>> asyncRequest) {
        CompletableFuture result = new CompletableFuture();
        this.attemptOperation(asyncRequest, result, 0);
        return result;
    }

    private <T> void attemptOperation(Supplier<CompletableFuture<T>> asyncRequest, CompletableFuture<T> result, int attempt) {
        CompletableFuture<T> f = asyncRequest.get();
        f.handleAsync((val, throwable) -> {
            if (throwable != null) {
                if (attempt < 10 && CompletableFutureUtil.unwrap(throwable) instanceof OptimisticLockingException) {
                    logger.debug("got optimistic locking exception - retrying", throwable);
                    this.attemptOperation(asyncRequest, result, attempt + 1);
                } else {
                    if (logger.isDebugEnabled()) {
                        logger.debug("got exception - NOT retrying: " + attempt, throwable);
                    }
                    result.completeExceptionally((Throwable)throwable);
                }
            } else {
                result.complete(val);
            }
            return null;
        });
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> update(String entityId, CT cmd, Optional<UpdateOptions> updateOptions) {
        return this.updateWithProvidedCommand(entityId, a -> Optional.of(cmd), updateOptions);
    }

    public CompletableFuture<EntityWithIdAndVersion<T>> updateWithProvidedCommand(String entityId, Function<T, Optional<CT>> commandProvider, Optional<UpdateOptions> updateOptions) {
        return this.withRetry(() -> {
            CompletionStage eo = this.aggregateStore.find(this.clasz, entityId, updateOptions.map(uo -> new FindOptions().withTriggeringEvent(uo.getTriggeringEvent()))).handleAsync((tEntityWithMetadata, throwable) -> {
                if (throwable == null) {
                    return new LoadedEntityWithMetadata(true, tEntityWithMetadata);
                }
                logger.debug("Exception finding aggregate", throwable);
                Throwable unwrapped = CompletableFutureUtil.unwrap(throwable);
                if (unwrapped instanceof DuplicateTriggeringEventException) {
                    return new LoadedEntityWithMetadata(false, null);
                }
                if (unwrapped instanceof RuntimeException) {
                    throw (RuntimeException)unwrapped;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException((Throwable)throwable);
            });
            return ((CompletableFuture)eo).thenCompose(loadedEntityWithMetadata -> {
                if (loadedEntityWithMetadata.success) {
                    EntityWithMetadata entityWithMetaData = loadedEntityWithMetadata.ewmd;
                    CommandProcessingAggregate aggregate = (CommandProcessingAggregate)entityWithMetaData.getEntity();
                    CommandOutcome commandResult = ((Optional)commandProvider.apply(aggregate)).map(command -> {
                        try {
                            return new CommandOutcome(aggregate.processCommand(command));
                        }
                        catch (EventuateCommandProcessingFailedException e) {
                            return new CommandOutcome(e.getCause());
                        }
                    }).orElse(new CommandOutcome(Collections.emptyList()));
                    UpdateEventsAndOptions transformed = this.transformUpdateEventsAndOptions(updateOptions, aggregate, commandResult);
                    List<Event> transformedEvents = transformed.getEvents();
                    Optional<UpdateOptions> transformedOptions = transformed.getOptions();
                    if (transformedEvents.isEmpty()) {
                        return CompletableFuture.completedFuture(entityWithMetaData.toEntityWithIdAndVersion());
                    }
                    CompletableFuture result = new CompletableFuture();
                    ((CompletableFuture)this.aggregateStore.update(this.clasz, entityWithMetaData.getEntityIdAndVersion(), transformedEvents, this.withPossibleSnapshot(transformedOptions, aggregate, entityWithMetaData.getSnapshotVersion(), loadedEntityWithMetadata.ewmd.getEvents(), transformedEvents)).thenApply(entityIdAndVersion -> new EntityWithIdAndVersion<CommandProcessingAggregate>((EntityIdAndVersion)entityIdAndVersion, aggregate))).handle((r, t) -> {
                        if (t == null) {
                            result.complete(r);
                        } else {
                            logger.debug("Exception updating aggregate", t);
                            Throwable unwrapped = CompletableFutureUtil.unwrap(t);
                            if (unwrapped instanceof DuplicateTriggeringEventException) {
                                this.aggregateStore.find(this.clasz, entityId, Optional.empty()).handle((reloadedAggregate, findException) -> {
                                    if (findException == null) {
                                        result.complete(new EntityWithIdAndVersion<CommandProcessingAggregate>(reloadedAggregate.getEntityIdAndVersion(), (CommandProcessingAggregate)reloadedAggregate.getEntity()));
                                    } else {
                                        result.completeExceptionally((Throwable)findException);
                                    }
                                    return null;
                                });
                            } else {
                                result.completeExceptionally(unwrapped);
                            }
                        }
                        return null;
                    });
                    return result;
                }
                return this.aggregateStore.find(this.clasz, entityId, Optional.empty()).thenApply(EntityWithMetadata::toEntityWithIdAndVersion);
            });
        });
    }

    private Optional<UpdateOptions> withPossibleSnapshot(Optional<UpdateOptions> updateOptions, T aggregate, Optional<Int128> snapshotVersion, List<EventWithMetadata> oldEvents, List<Event> newEvents) {
        Optional optionsWithSnapshot = this.aggregateStore.possiblySnapshot((Aggregate)aggregate, snapshotVersion, oldEvents, newEvents).flatMap(snapshot -> Optional.of(updateOptions.orElse(new UpdateOptions()).withSnapshot((Snapshot)snapshot)));
        return optionsWithSnapshot.isPresent() ? optionsWithSnapshot : updateOptions;
    }

    public CompletableFuture<EntityWithMetadata<T>> find(String entityId) {
        return this.aggregateStore.find(this.clasz, entityId);
    }

    public CompletableFuture<EntityWithMetadata<T>> find(String entityId, FindOptions findOptions) {
        return this.aggregateStore.find(this.clasz, entityId, findOptions);
    }

    public CompletableFuture<EntityWithMetadata<T>> find(String entityId, Optional<FindOptions> findOptions) {
        return this.aggregateStore.find(this.clasz, entityId, findOptions);
    }

    class LoadedEntityWithMetadata {
        boolean success;
        EntityWithMetadata<T> ewmd;

        LoadedEntityWithMetadata(boolean success, EntityWithMetadata<T> ewmd) {
            this.success = success;
            this.ewmd = ewmd;
        }
    }
}

