/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate;

import io.eventuate.Aggregate;
import io.eventuate.Event;
import io.eventuate.MissingApplyEventMethodStrategy;
import io.eventuate.MissingApplyMethodException;
import java.util.List;

public class Aggregates {
    public static <T extends Aggregate<T>> T applyEventsToMutableAggregate(T aggregate, List<Event> events, MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        for (Event event : events) {
            try {
                aggregate = aggregate.applyEvent(event);
            }
            catch (MissingApplyMethodException e) {
                missingApplyEventMethodStrategy.handle(aggregate, e);
            }
        }
        return aggregate;
    }

    public static <T extends Aggregate<T>> T recreateAggregate(Class<T> clasz, List<Event> events, MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        return Aggregates.applyEventsToMutableAggregate(Aggregates.newAggregate(clasz), events, missingApplyEventMethodStrategy);
    }

    private static <T extends Aggregate<T>> T newAggregate(Class<T> clasz) {
        try {
            return (T)((Aggregate)clasz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

