/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate;

import io.eventuate.AggregateRepositoryInterceptor;
import io.eventuate.Aggregates;
import io.eventuate.Command;
import io.eventuate.CommandOutcome;
import io.eventuate.CommandProcessingAggregate;
import io.eventuate.DefaultAggregateRepositoryInterceptor;
import io.eventuate.DefaultMissingApplyEventMethodStrategy;
import io.eventuate.Event;
import io.eventuate.EventuateCommandProcessingFailedException;
import io.eventuate.MissingApplyEventMethodStrategy;
import io.eventuate.UpdateEventsAndOptions;
import io.eventuate.UpdateOptions;
import java.util.List;
import java.util.Optional;

public abstract class CommonAggregateRepository<T extends CommandProcessingAggregate<T, CT>, CT extends Command> {
    protected Class<T> clasz;
    protected AggregateRepositoryInterceptor<T, CT> interceptor = new DefaultAggregateRepositoryInterceptor();
    protected MissingApplyEventMethodStrategy missingApplyEventMethodStrategy = new DefaultMissingApplyEventMethodStrategy();

    public CommonAggregateRepository(Class<T> clasz) {
        this.clasz = clasz;
    }

    public void setMissingApplyEventMethodStrategy(MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        this.missingApplyEventMethodStrategy = missingApplyEventMethodStrategy;
    }

    public void setInterceptor(AggregateRepositoryInterceptor<T, CT> interceptor) {
        this.interceptor = interceptor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected UpdateEventsAndOptions transformUpdateEventsAndOptions(Optional<UpdateOptions> updateOptions, T aggregate, CommandOutcome commandResult) {
        if (commandResult.isFailure()) {
            Optional<UpdateEventsAndOptions> handled = this.effectiveInterceptor(updateOptions).handleException(aggregate, commandResult.throwable, updateOptions);
            if (!handled.isPresent()) throw new EventuateCommandProcessingFailedException(commandResult.throwable);
            return handled.get();
        }
        List<Event> events = commandResult.result;
        Aggregates.applyEventsToMutableAggregate(aggregate, events, this.missingApplyEventMethodStrategy);
        UpdateEventsAndOptions original = new UpdateEventsAndOptions(events, updateOptions);
        return this.effectiveInterceptor(updateOptions).transformUpdate(aggregate, original);
    }

    private AggregateRepositoryInterceptor effectiveInterceptor(Optional<UpdateOptions> updateOptions) {
        return updateOptions.flatMap(uo -> uo.getInterceptor()).orElse(this.interceptor);
    }
}

