/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate;

import io.eventuate.Aggregate;
import io.eventuate.DefaultMissingApplyEventMethodStrategy;
import io.eventuate.MissingApplyEventMethodStrategy;
import io.eventuate.MissingApplyMethodException;
import java.util.Arrays;

public class CompositeMissingApplyEventMethodStrategy {
    private MissingApplyEventMethodStrategy[] strategies;
    private DefaultMissingApplyEventMethodStrategy defaultStrategy = new DefaultMissingApplyEventMethodStrategy();

    public CompositeMissingApplyEventMethodStrategy(MissingApplyEventMethodStrategy[] strategies) {
        this.strategies = strategies;
    }

    public boolean supports(Aggregate aggregate, MissingApplyMethodException e) {
        return Arrays.stream(this.strategies).anyMatch(s -> s.supports(aggregate, e));
    }

    public void handle(Aggregate aggregate, MissingApplyMethodException e) {
        for (MissingApplyEventMethodStrategy strategy : this.strategies) {
            if (!strategy.supports(aggregate, e)) continue;
            strategy.handle(aggregate, e);
            return;
        }
        this.defaultStrategy.handle(aggregate, e);
    }

    public MissingApplyEventMethodStrategy toMissingApplyEventMethodStrategy() {
        return new MissingApplyEventMethodStrategy(){

            @Override
            public boolean supports(Aggregate aggregate, MissingApplyMethodException e) {
                return CompositeMissingApplyEventMethodStrategy.this.supports(aggregate, e);
            }

            @Override
            public void handle(Aggregate aggregate, MissingApplyMethodException e) {
                CompositeMissingApplyEventMethodStrategy.this.handle(aggregate, e);
            }
        };
    }
}

