/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate;

import io.eventuate.Aggregate;
import io.eventuate.Event;
import io.eventuate.EventWithMetadata;
import io.eventuate.MissingApplyEventMethodStrategy;
import io.eventuate.Snapshot;
import io.eventuate.SnapshotManager;
import io.eventuate.SnapshotStrategy;
import io.eventuate.common.id.Int128;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SnapshotManagerImpl
implements SnapshotManager {
    private Map<Class<?>, SnapshotStrategy> strategies = new HashMap();

    public void addStrategy(SnapshotStrategy snapshotStrategy) {
        this.strategies.put(snapshotStrategy.getAggregateClass(), snapshotStrategy);
    }

    @Override
    public Optional<Snapshot> possiblySnapshot(Aggregate aggregate, Optional<Int128> snapshotVersion, List<EventWithMetadata> oldEvents, List<Event> newEvents) {
        SnapshotStrategy strategy = this.strategies.get(aggregate.getClass());
        if (strategy == null) {
            return Optional.empty();
        }
        return strategy.possiblySnapshot(aggregate, snapshotVersion, oldEvents, newEvents);
    }

    @Override
    public Aggregate recreateFromSnapshot(Class<?> clasz, Snapshot snapshot, MissingApplyEventMethodStrategy missingApplyEventMethodStrategy) {
        SnapshotStrategy strategy = this.strategies.get(clasz);
        return strategy.recreateAggregate(clasz, snapshot, missingApplyEventMethodStrategy);
    }
}

