/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.sync;

import io.eventuate.Aggregate;
import io.eventuate.Aggregates;
import io.eventuate.Command;
import io.eventuate.CommandOutcome;
import io.eventuate.CommandProcessingAggregate;
import io.eventuate.CommonAggregateRepository;
import io.eventuate.DuplicateTriggeringEventException;
import io.eventuate.EntityIdAndVersion;
import io.eventuate.EntityWithIdAndVersion;
import io.eventuate.EntityWithMetadata;
import io.eventuate.Event;
import io.eventuate.EventWithMetadata;
import io.eventuate.FindOptions;
import io.eventuate.OptimisticLockingException;
import io.eventuate.SaveOptions;
import io.eventuate.Snapshot;
import io.eventuate.UpdateEventsAndOptions;
import io.eventuate.UpdateOptions;
import io.eventuate.common.id.Int128;
import io.eventuate.sync.EventuateAggregateStoreCrud;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateRepository<T extends CommandProcessingAggregate<T, CT>, CT extends Command>
extends CommonAggregateRepository<T, CT> {
    private static Logger logger = LoggerFactory.getLogger(AggregateRepository.class);
    private EventuateAggregateStoreCrud aggregateStore;

    public AggregateRepository(Class<T> clasz, EventuateAggregateStoreCrud aggregateStore) {
        super(clasz);
        this.aggregateStore = aggregateStore;
    }

    public EntityWithIdAndVersion<T> save(CT cmd) {
        return this.save(cmd, Optional.empty());
    }

    public EntityWithIdAndVersion<T> save(CT cmd, Optional<SaveOptions> saveOptions) {
        CommandProcessingAggregate aggregate;
        try {
            aggregate = (CommandProcessingAggregate)this.clasz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
        List<Event> events = aggregate.processCommand(cmd);
        Aggregates.applyEventsToMutableAggregate(aggregate, events, this.missingApplyEventMethodStrategy);
        return new EntityWithIdAndVersion<CommandProcessingAggregate>(this.aggregateStore.save(this.clasz, events, saveOptions), aggregate);
    }

    public EntityWithIdAndVersion<T> update(String entityId, CT cmd) {
        return this.update(entityId, cmd, Optional.empty());
    }

    private <T> T withRetry(Supplier<T> asyncRequest) {
        OptimisticLockingException laste = null;
        int MAX_RETRIES = 10;
        for (int attempt = 0; attempt < MAX_RETRIES; ++attempt) {
            if (laste != null) {
                logger.debug("got optimistic locking exception - retrying", laste);
            }
            try {
                return asyncRequest.get();
            }
            catch (OptimisticLockingException e) {
                laste = e;
                continue;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("got exception - NOT retrying: " + MAX_RETRIES, (Throwable)laste);
        }
        throw laste;
    }

    public EntityWithIdAndVersion<T> update(String entityId, CT cmd, Optional<UpdateOptions> updateOptions) {
        return this.updateWithProvidedCommand(entityId, a -> Optional.of(cmd), updateOptions);
    }

    public EntityWithIdAndVersion<T> updateWithProvidedCommand(String entityId, Function<T, Optional<CT>> commandProvider, Optional<UpdateOptions> updateOptions) {
        return this.withRetry(() -> {
            CommandOutcome commandResult;
            EntityWithMetadata entityWithMetadata;
            try {
                entityWithMetadata = this.aggregateStore.find(this.clasz, entityId, updateOptions.map(uo -> new FindOptions().withTriggeringEvent(uo.getTriggeringEvent())));
            }
            catch (DuplicateTriggeringEventException dtee) {
                return this.aggregateStore.find(this.clasz, entityId, Optional.empty()).toEntityWithIdAndVersion();
            }
            CommandProcessingAggregate aggregate = (CommandProcessingAggregate)entityWithMetadata.getEntity();
            try {
                commandResult = new CommandOutcome(((Optional)commandProvider.apply(aggregate)).map(aggregate::processCommand).orElse(Collections.emptyList()));
            }
            catch (Throwable e) {
                commandResult = new CommandOutcome(e);
            }
            UpdateEventsAndOptions transformed = this.transformUpdateEventsAndOptions(updateOptions, aggregate, commandResult);
            List<Event> transformedEvents = transformed.getEvents();
            Optional<UpdateOptions> transformedOptions = transformed.getOptions();
            if (transformedEvents.isEmpty()) {
                return entityWithMetadata.toEntityWithIdAndVersion();
            }
            try {
                EntityIdAndVersion entityIdAndVersion = this.aggregateStore.update(this.clasz, entityWithMetadata.getEntityIdAndVersion(), transformedEvents, this.withPossibleSnapshot(transformedOptions, aggregate, entityWithMetadata.getSnapshotVersion(), entityWithMetadata.getEvents(), transformedEvents));
                return new EntityWithIdAndVersion<CommandProcessingAggregate>(entityIdAndVersion, aggregate);
            }
            catch (DuplicateTriggeringEventException e) {
                EntityWithMetadata reloadedEntity = this.aggregateStore.find(this.clasz, entityId, updateOptions.map(uo -> new FindOptions().withTriggeringEvent(uo.getTriggeringEvent())));
                return new EntityWithIdAndVersion<CommandProcessingAggregate>(reloadedEntity.getEntityIdAndVersion(), aggregate);
            }
        });
    }

    private Optional<UpdateOptions> withPossibleSnapshot(Optional<UpdateOptions> updateOptions, T aggregate, Optional<Int128> snapshotVersion, List<EventWithMetadata> oldEvents, List<Event> newEvents) {
        Optional optionsWithSnapshot = this.aggregateStore.possiblySnapshot((Aggregate)aggregate, snapshotVersion, oldEvents, newEvents).flatMap(snapshot -> Optional.of(updateOptions.orElse(new UpdateOptions()).withSnapshot((Snapshot)snapshot)));
        return optionsWithSnapshot.isPresent() ? optionsWithSnapshot : updateOptions;
    }

    public EntityWithMetadata<T> find(String entityId) {
        return this.aggregateStore.find(this.clasz, entityId);
    }

    public EntityWithMetadata<T> find(String entityId, FindOptions findOptions) {
        return this.aggregateStore.find(this.clasz, entityId, findOptions);
    }

    public EntityWithMetadata<T> find(String entityId, Optional<FindOptions> findOptions) {
        return this.aggregateStore.find(this.clasz, entityId, findOptions);
    }

    class LoadedEntityWithMetadata {
        boolean success;
        EntityWithMetadata<T> ewmd;

        LoadedEntityWithMetadata(boolean success, EntityWithMetadata<T> ewmd) {
            this.success = success;
            this.ewmd = ewmd;
        }
    }
}

