/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.messaging.kafka.basic.consumer;

import io.eventuate.messaging.kafka.basic.consumer.BackPressureActions;
import io.eventuate.messaging.kafka.basic.consumer.BackPressureConfig;
import io.eventuate.messaging.kafka.basic.consumer.BackPressureManagerNormalState;
import io.eventuate.messaging.kafka.basic.consumer.BackPressureManagerState;
import io.eventuate.messaging.kafka.basic.consumer.BackPressureManagerStateAndActions;
import java.util.HashSet;
import java.util.Set;
import org.apache.kafka.common.TopicPartition;

public class BackPressureManagerPausedState
implements BackPressureManagerState {
    private Set<TopicPartition> suspendedPartitions;

    public BackPressureManagerPausedState(Set<TopicPartition> pausedTopic) {
        this.suspendedPartitions = new HashSet<TopicPartition>(pausedTopic);
    }

    public static BackPressureManagerStateAndActions transitionTo(Set<TopicPartition> allTopicPartitions) {
        return new BackPressureManagerStateAndActions(BackPressureActions.pause(allTopicPartitions), new BackPressureManagerPausedState(allTopicPartitions));
    }

    @Override
    public BackPressureManagerStateAndActions update(Set<TopicPartition> allTopicPartitions, int backlog, BackPressureConfig backPressureConfig) {
        if (backlog <= backPressureConfig.getLow()) {
            return BackPressureManagerNormalState.transitionTo(this.suspendedPartitions);
        }
        HashSet<TopicPartition> toSuspend = new HashSet<TopicPartition>(allTopicPartitions);
        toSuspend.removeAll(this.suspendedPartitions);
        this.suspendedPartitions.addAll(toSuspend);
        return new BackPressureManagerStateAndActions(BackPressureActions.pause(toSuspend), this);
    }
}

