/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.messaging.kafka.basic.consumer;

import io.eventuate.messaging.kafka.basic.consumer.KafkaMessageConsumer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;

public class DefaultKafkaMessageConsumer
implements KafkaMessageConsumer {
    private final KafkaConsumer<String, byte[]> delegate;

    public static KafkaMessageConsumer create(Properties properties) {
        return new DefaultKafkaMessageConsumer((KafkaConsumer<String, byte[]>)new KafkaConsumer(properties));
    }

    private DefaultKafkaMessageConsumer(KafkaConsumer<String, byte[]> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void assign(Collection<TopicPartition> topicPartitions) {
        this.delegate.assign(topicPartitions);
    }

    @Override
    public void seekToEnd(Collection<TopicPartition> topicPartitions) {
        this.delegate.seekToEnd(topicPartitions);
    }

    @Override
    public long position(TopicPartition topicPartition) {
        return this.delegate.position(topicPartition);
    }

    @Override
    public void seek(TopicPartition topicPartition, long position) {
        this.delegate.seek(topicPartition, position);
    }

    @Override
    public void subscribe(List<String> topics) {
        this.delegate.subscribe(new ArrayList<String>(topics));
    }

    @Override
    public void commitOffsets(Map<TopicPartition, OffsetAndMetadata> offsets) {
        this.delegate.commitSync(offsets);
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        return this.delegate.partitionsFor(topic);
    }

    @Override
    public ConsumerRecords<String, byte[]> poll(Duration duration) {
        return this.delegate.poll(duration);
    }

    @Override
    public void pause(Set<TopicPartition> partitions) {
        this.delegate.pause(partitions);
    }

    @Override
    public void resume(Set<TopicPartition> partitions) {
        this.delegate.resume(partitions);
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void close(Duration duration) {
        this.delegate.close(duration);
    }
}

