/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.messaging.kafka.basic.consumer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.ToStringBuilder;

public class TopicPartitionOffsets {
    private SortedSet<Long> unprocessed = new TreeSet<Long>();
    private Set<Long> processed = new HashSet<Long>();

    public String toString() {
        return new ToStringBuilder((Object)this).append("unprocessed", this.unprocessed).append("processed", this.processed).toString();
    }

    public void noteUnprocessed(long offset) {
        this.unprocessed.add(offset);
    }

    public void noteProcessed(long offset) {
        this.processed.add(offset);
    }

    Optional<Long> offsetToCommit() {
        long x;
        Long result = null;
        Iterator iterator = this.unprocessed.iterator();
        while (iterator.hasNext() && this.processed.contains(x = ((Long)iterator.next()).longValue())) {
            result = x;
        }
        return Optional.ofNullable(result);
    }

    public void noteOffsetCommitted(long offset) {
        this.unprocessed = new TreeSet<Long>(this.unprocessed.stream().filter(x -> x > offset).collect(Collectors.toList()));
        this.processed = this.processed.stream().filter(x -> x > offset).collect(Collectors.toSet());
    }

    public Set<Long> getPending() {
        HashSet<Long> result = new HashSet<Long>(this.unprocessed);
        result.removeAll(this.processed);
        return result;
    }
}

