/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.common;

import io.eventuate.common.jdbc.EventuateDuplicateKeyException;
import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.common.jdbc.EventuateSchema;
import io.eventuate.common.json.mapper.JSonMapper;
import io.eventuate.tram.messaging.common.Message;
import io.eventuate.tram.messaging.producer.MessageBuilder;
import io.eventuate.tram.sagas.common.SagaLockManager;
import io.eventuate.tram.sagas.common.SagaLockManagerSql;
import io.eventuate.tram.sagas.common.StashedMessage;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaLockManagerImpl
implements SagaLockManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor;
    private SagaLockManagerSql sagaLockManagerSql;

    public SagaLockManagerImpl(EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor, EventuateSchema eventuateSchema) {
        this.eventuateJdbcStatementExecutor = eventuateJdbcStatementExecutor;
        this.sagaLockManagerSql = new SagaLockManagerSql(eventuateSchema);
    }

    @Override
    public boolean claimLock(String sagaType, String sagaId, String target) {
        while (true) {
            try {
                this.eventuateJdbcStatementExecutor.update(this.sagaLockManagerSql.getInsertIntoSagaLockTableSql(), new Object[]{target, sagaType, sagaId});
                this.logger.debug("Saga {} {} has locked {}", new Object[]{sagaType, sagaId, target});
                return true;
            }
            catch (EventuateDuplicateKeyException e) {
                Optional<String> owningSagaId = this.selectForUpdate(target);
                if (owningSagaId.isPresent()) {
                    if (owningSagaId.get().equals(sagaId)) {
                        return true;
                    }
                    this.logger.debug("Saga {} {} is blocked by {} which has locked {}", new Object[]{sagaType, sagaId, owningSagaId, target});
                    return false;
                }
                this.logger.debug("{}  is repeating attempt to lock {}", (Object)sagaId, (Object)target);
                continue;
            }
            break;
        }
    }

    private Optional<String> selectForUpdate(String target) {
        return this.eventuateJdbcStatementExecutor.query(this.sagaLockManagerSql.getSelectFromSagaLockTableSql(), (rs, rowNum) -> rs.getString("saga_id"), new Object[]{target}).stream().findFirst();
    }

    @Override
    public void stashMessage(String sagaType, String sagaId, String target, Message message) {
        this.logger.debug("Stashing message from {} for {} : {}", new Object[]{sagaId, target, message});
        this.eventuateJdbcStatementExecutor.update(this.sagaLockManagerSql.getInsertIntoSagaStashTableSql(), new Object[]{message.getRequiredHeader("ID"), target, sagaType, sagaId, JSonMapper.toJson((Object)message.getHeaders()), message.getPayload()});
    }

    @Override
    public Optional<Message> unlock(String sagaId, String target) {
        Optional<String> owningSagaId = this.selectForUpdate(target);
        if (!owningSagaId.isPresent()) {
            throw new RuntimeException("owningSagaId is not present");
        }
        if (!owningSagaId.get().equals(sagaId)) {
            throw new RuntimeException(String.format("Expected owner to be %s but is %s", sagaId, owningSagaId.get()));
        }
        this.logger.debug("Saga {} has unlocked {}", (Object)sagaId, (Object)target);
        List stashedMessages = this.eventuateJdbcStatementExecutor.query(this.sagaLockManagerSql.getSelectFromSagaStashTableSql(), (rs, rowNum) -> new StashedMessage(rs.getString("saga_type"), rs.getString("saga_id"), MessageBuilder.withPayload((String)rs.getString("message_payload")).withExtraHeaders("", (Map)JSonMapper.fromJson((String)rs.getString("message_headers"), Map.class)).build()), new Object[]{target});
        if (stashedMessages.isEmpty()) {
            this.assertEqualToOne(this.eventuateJdbcStatementExecutor.update(this.sagaLockManagerSql.getDeleteFromSagaLockTableSql(), new Object[]{target}));
            return Optional.empty();
        }
        StashedMessage stashedMessage = (StashedMessage)stashedMessages.get(0);
        this.logger.debug("unstashed from {}  for {} : {}", new Object[]{sagaId, target, stashedMessage.getMessage()});
        this.assertEqualToOne(this.eventuateJdbcStatementExecutor.update(this.sagaLockManagerSql.getUpdateSagaLockTableSql(), new Object[]{stashedMessage.getSagaType(), stashedMessage.getSagaId(), target}));
        this.assertEqualToOne(this.eventuateJdbcStatementExecutor.update(this.sagaLockManagerSql.getDeleteFromSagaStashTableSql(), new Object[]{stashedMessage.getMessage().getId()}));
        return Optional.of(stashedMessage.getMessage());
    }

    private void assertEqualToOne(int n) {
        if (n != 1) {
            throw new RuntimeException("Expected to update one row but updated: " + n);
        }
    }
}

