/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.simpledsl;

import io.eventuate.common.json.mapper.JSonMapper;
import io.eventuate.tram.messaging.common.Message;
import io.eventuate.tram.sagas.orchestration.SagaActions;
import io.eventuate.tram.sagas.simpledsl.AbstractSagaActionsProvider;
import io.eventuate.tram.sagas.simpledsl.AbstractStepToExecute;
import io.eventuate.tram.sagas.simpledsl.ISagaStep;
import io.eventuate.tram.sagas.simpledsl.SagaExecutionState;
import io.eventuate.tram.sagas.simpledsl.SagaExecutionStateJsonSerde;
import java.util.List;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSimpleSagaDefinition<Data, Step extends ISagaStep<Data>, ToExecute extends AbstractStepToExecute<Data, Step>, Provider extends AbstractSagaActionsProvider<Data, ?>> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    protected List<Step> steps;

    public AbstractSimpleSagaDefinition(List<Step> steps) {
        this.steps = steps;
    }

    protected Provider firstStepToExecute(Data data) {
        return this.nextStepToExecute(SagaExecutionState.startingState(), data);
    }

    protected Provider handleFailedCompensatingTransaction(String sagaType, String sagaId, SagaExecutionState state, Message message) {
        this.logger.error("Saga {} {} failed due to failed compensating transaction {}", new Object[]{sagaType, sagaId, message});
        return this.makeSagaActionsProvider(SagaActions.builder().withUpdatedState(SagaExecutionStateJsonSerde.encodeState(SagaExecutionState.makeFailedEndState())).withIsEndState(true).withIsCompensating(state.isCompensating()).withIsFailed(true).build());
    }

    protected Provider sagaActionsForNextStep(String sagaType, String sagaId, Data sagaData, Message message, SagaExecutionState state, Step currentStep, boolean compensating) {
        if (currentStep.isSuccessfulReply(compensating, message)) {
            return this.nextStepToExecute(state, sagaData);
        }
        if (compensating) {
            return this.handleFailedCompensatingTransaction(sagaType, sagaId, state, message);
        }
        return this.nextStepToExecute(state.startCompensating(), sagaData);
    }

    protected Provider nextStepToExecute(SagaExecutionState state, Data data) {
        int skipped = 0;
        boolean compensating = state.isCompensating();
        int direction = compensating ? -1 : 1;
        for (int i = state.getCurrentlyExecuting() + direction; i >= 0 && i < this.steps.size(); i += direction) {
            ISagaStep step = (ISagaStep)this.steps.get(i);
            if (compensating ? step.hasCompensation(data) : step.hasAction(data)) {
                ToExecute stepToExecute = this.makeStepToExecute(skipped, compensating, step);
                return this.makeSagaActionsProvider(stepToExecute, data, state);
            }
            ++skipped;
        }
        return this.makeSagaActionsProvider(this.makeEndStateSagaActions(state));
    }

    protected <T> T invokeReplyHandler(Message message, Data data, BiFunction<Data, Object, T> handler) {
        Class<?> m;
        try {
            String className = message.getRequiredHeader("reply_type");
            m = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Class not found", (Throwable)e);
            throw new RuntimeException("Class not found", e);
        }
        Object reply = JSonMapper.fromJson((String)message.getPayload(), m);
        return handler.apply(data, reply);
    }

    protected SagaActions<Data> makeEndStateSagaActions(SagaExecutionState state) {
        return SagaActions.builder().withUpdatedState(SagaExecutionStateJsonSerde.encodeState(SagaExecutionState.makeEndState())).withIsEndState(true).withIsCompensating(state.isCompensating()).build();
    }

    protected abstract ToExecute makeStepToExecute(int var1, boolean var2, Step var3);

    protected abstract Provider makeSagaActionsProvider(SagaActions<Data> var1);

    protected abstract Provider makeSagaActionsProvider(ToExecute var1, Data var2, SagaExecutionState var3);
}

