/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.simpledsl;

import io.eventuate.tram.commands.common.Command;
import io.eventuate.tram.commands.consumer.CommandWithDestination;
import io.eventuate.tram.sagas.orchestration.SagaDefinition;
import io.eventuate.tram.sagas.simpledsl.CommandEndpoint;
import io.eventuate.tram.sagas.simpledsl.ParticipantEndpointInvocationImpl;
import io.eventuate.tram.sagas.simpledsl.ParticipantInvocation;
import io.eventuate.tram.sagas.simpledsl.ParticipantInvocationImpl;
import io.eventuate.tram.sagas.simpledsl.ParticipantInvocationStep;
import io.eventuate.tram.sagas.simpledsl.SimpleSagaDefinitionBuilder;
import io.eventuate.tram.sagas.simpledsl.StepBuilder;
import io.eventuate.tram.sagas.simpledsl.WithCompensationBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public class InvokeParticipantStepBuilder<Data>
implements WithCompensationBuilder<Data> {
    private final SimpleSagaDefinitionBuilder<Data> parent;
    private Optional<ParticipantInvocation<Data>> action = Optional.empty();
    private Optional<ParticipantInvocation<Data>> compensation = Optional.empty();
    private Map<String, BiConsumer<Data, Object>> actionReplyHandlers = new HashMap<String, BiConsumer<Data, Object>>();
    private Map<String, BiConsumer<Data, Object>> compensationReplyHandlers = new HashMap<String, BiConsumer<Data, Object>>();

    public InvokeParticipantStepBuilder(SimpleSagaDefinitionBuilder<Data> parent) {
        this.parent = parent;
    }

    InvokeParticipantStepBuilder<Data> withAction(Optional<Predicate<Data>> participantInvocationPredicate, Function<Data, CommandWithDestination> action) {
        this.action = Optional.of(new ParticipantInvocationImpl(participantInvocationPredicate, action));
        return this;
    }

    <C extends Command> InvokeParticipantStepBuilder<Data> withAction(Optional<Predicate<Data>> participantInvocationPredicate, CommandEndpoint<C> commandEndpoint, Function<Data, C> commandProvider) {
        this.action = Optional.of(new ParticipantEndpointInvocationImpl<Data, C>(participantInvocationPredicate, commandEndpoint, commandProvider));
        return this;
    }

    @Override
    public InvokeParticipantStepBuilder<Data> withCompensation(Function<Data, CommandWithDestination> compensation) {
        this.compensation = Optional.of(new ParticipantInvocationImpl(Optional.empty(), compensation));
        return this;
    }

    @Override
    public InvokeParticipantStepBuilder<Data> withCompensation(Predicate<Data> compensationPredicate, Function<Data, CommandWithDestination> compensation) {
        this.compensation = Optional.of(new ParticipantInvocationImpl(Optional.of(compensationPredicate), compensation));
        return this;
    }

    @Override
    public <C extends Command> InvokeParticipantStepBuilder<Data> withCompensation(CommandEndpoint<C> commandEndpoint, Function<Data, C> commandProvider) {
        this.compensation = Optional.of(new ParticipantEndpointInvocationImpl(Optional.empty(), commandEndpoint, commandProvider));
        return this;
    }

    @Override
    public <C extends Command> InvokeParticipantStepBuilder<Data> withCompensation(Predicate<Data> compensationPredicate, CommandEndpoint<C> commandEndpoint, Function<Data, C> commandProvider) {
        this.compensation = Optional.of(new ParticipantEndpointInvocationImpl<Data, C>(Optional.of(compensationPredicate), commandEndpoint, commandProvider));
        return this;
    }

    public <T> InvokeParticipantStepBuilder<Data> onReply(Class<T> replyClass, BiConsumer<Data, T> replyHandler) {
        if (this.compensation.isPresent()) {
            this.compensationReplyHandlers.put(replyClass.getName(), (data, rawReply) -> replyHandler.accept(data, rawReply));
        } else {
            this.actionReplyHandlers.put(replyClass.getName(), (data, rawReply) -> replyHandler.accept(data, rawReply));
        }
        return this;
    }

    public StepBuilder<Data> step() {
        this.addStep();
        return new StepBuilder<Data>(this.parent);
    }

    public SagaDefinition<Data> build() {
        this.addStep();
        return this.parent.build();
    }

    private void addStep() {
        this.parent.addStep(new ParticipantInvocationStep<Data>(this.action, this.compensation, this.actionReplyHandlers, this.compensationReplyHandlers));
    }
}

