/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.simpledsl;

import io.eventuate.tram.commands.common.CommandReplyOutcome;
import io.eventuate.tram.messaging.common.Message;
import io.eventuate.tram.sagas.simpledsl.SagaStep;
import io.eventuate.tram.sagas.simpledsl.StepOutcome;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class LocalStep<Data>
implements SagaStep<Data> {
    private Consumer<Data> localFunction;
    private Optional<Consumer<Data>> compensation;

    public LocalStep(Consumer<Data> localFunction, Optional<Consumer<Data>> compensation) {
        this.localFunction = localFunction;
        this.compensation = compensation;
    }

    @Override
    public boolean hasAction(Data data) {
        return true;
    }

    @Override
    public boolean hasCompensation(Data data) {
        return this.compensation.isPresent();
    }

    @Override
    public boolean isSuccessfulReply(boolean compensating, Message message) {
        return CommandReplyOutcome.SUCCESS.name().equals(message.getRequiredHeader("reply_outcome-type"));
    }

    @Override
    public Optional<BiConsumer<Data, Object>> getReplyHandler(Message message, boolean compensating) {
        return Optional.empty();
    }

    @Override
    public StepOutcome makeStepOutcome(Data data, boolean compensating) {
        try {
            if (compensating) {
                this.compensation.ifPresent(localStep -> localStep.accept(data));
            } else {
                this.localFunction.accept(data);
            }
            return StepOutcome.makeLocalOutcome(Optional.empty());
        }
        catch (RuntimeException e) {
            return StepOutcome.makeLocalOutcome(Optional.of(e));
        }
    }
}

