/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.simpledsl;

import io.eventuate.tram.sagas.orchestration.SagaDefinition;
import io.eventuate.tram.sagas.simpledsl.LocalStep;
import io.eventuate.tram.sagas.simpledsl.SimpleSagaDefinitionBuilder;
import io.eventuate.tram.sagas.simpledsl.StepBuilder;
import java.util.Optional;
import java.util.function.Consumer;

public class LocalStepBuilder<Data> {
    private final SimpleSagaDefinitionBuilder<Data> parent;
    private final Consumer<Data> localFunction;
    private Optional<Consumer<Data>> compensation = Optional.empty();

    public LocalStepBuilder(SimpleSagaDefinitionBuilder<Data> parent, Consumer<Data> localFunction) {
        this.parent = parent;
        this.localFunction = localFunction;
    }

    public LocalStepBuilder<Data> withCompensation(Consumer<Data> localCompensation) {
        this.compensation = Optional.of(localCompensation);
        return this;
    }

    public StepBuilder<Data> step() {
        this.parent.addStep(new LocalStep<Data>(this.localFunction, this.compensation));
        return new StepBuilder<Data>(this.parent);
    }

    public SagaDefinition<Data> build() {
        this.parent.addStep(new LocalStep<Data>(this.localFunction, this.compensation));
        return this.parent.build();
    }
}

