/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.simpledsl;

import io.eventuate.tram.messaging.common.Message;
import io.eventuate.tram.sagas.simpledsl.ParticipantInvocation;
import io.eventuate.tram.sagas.simpledsl.SagaStep;
import io.eventuate.tram.sagas.simpledsl.StepOutcome;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;

public class ParticipantInvocationStep<Data>
implements SagaStep<Data> {
    private final Map<String, BiConsumer<Data, Object>> actionReplyHandlers;
    private final Map<String, BiConsumer<Data, Object>> compensationReplyHandlers;
    private Optional<ParticipantInvocation<Data>> participantInvocation;
    private Optional<ParticipantInvocation<Data>> compensation;

    public ParticipantInvocationStep(Optional<ParticipantInvocation<Data>> participantInvocation, Optional<ParticipantInvocation<Data>> compensation, Map<String, BiConsumer<Data, Object>> actionReplyHandlers, Map<String, BiConsumer<Data, Object>> compensationReplyHandlers) {
        this.actionReplyHandlers = actionReplyHandlers;
        this.compensationReplyHandlers = compensationReplyHandlers;
        this.participantInvocation = participantInvocation;
        this.compensation = compensation;
    }

    private Optional<ParticipantInvocation<Data>> getParticipantInvocation(boolean compensating) {
        return compensating ? this.compensation : this.participantInvocation;
    }

    @Override
    public boolean hasAction(Data data) {
        return this.participantInvocation.isPresent() && this.participantInvocation.map(p -> p.isInvocable(data)).orElse(true) != false;
    }

    @Override
    public boolean hasCompensation(Data data) {
        return this.compensation.isPresent() && this.compensation.map(p -> p.isInvocable(data)).orElse(true) != false;
    }

    @Override
    public Optional<BiConsumer<Data, Object>> getReplyHandler(Message message, boolean compensating) {
        String replyType = message.getRequiredHeader("reply_type");
        return Optional.ofNullable((compensating ? this.compensationReplyHandlers : this.actionReplyHandlers).get(replyType));
    }

    @Override
    public boolean isSuccessfulReply(boolean compensating, Message message) {
        return this.getParticipantInvocation(compensating).get().isSuccessfulReply(message);
    }

    @Override
    public StepOutcome makeStepOutcome(Data data, boolean compensating) {
        return StepOutcome.makeRemoteStepOutcome(this.getParticipantInvocation(compensating).map(x -> x.makeCommandToSend(data)).map(Collections::singletonList).orElseGet(Collections::emptyList));
    }
}

