/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.simpledsl;

import org.apache.commons.lang.builder.ToStringBuilder;

public class SagaExecutionState {
    private int currentlyExecuting;
    private boolean compensating;
    private boolean endState;
    private boolean failed;

    public static SagaExecutionState startingState() {
        return new SagaExecutionState(-1, false);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public SagaExecutionState() {
    }

    public SagaExecutionState(int currentlyExecuting, boolean compensating) {
        this.currentlyExecuting = currentlyExecuting;
        this.compensating = compensating;
    }

    public int getCurrentlyExecuting() {
        return this.currentlyExecuting;
    }

    public void setCurrentlyExecuting(int currentlyExecuting) {
        this.currentlyExecuting = currentlyExecuting;
    }

    public boolean isCompensating() {
        return this.compensating;
    }

    public void setCompensating(boolean compensating) {
        this.compensating = compensating;
    }

    public SagaExecutionState startCompensating() {
        return new SagaExecutionState(this.currentlyExecuting, true);
    }

    public SagaExecutionState nextState(int size) {
        return new SagaExecutionState(this.compensating ? this.currentlyExecuting - size : this.currentlyExecuting + size, this.compensating);
    }

    public boolean isEndState() {
        return this.endState;
    }

    public void setEndState(boolean endState) {
        this.endState = endState;
    }

    public void setFailed(boolean failed) {
        this.failed = failed;
    }

    public boolean isFailed() {
        return this.failed;
    }

    public static SagaExecutionState makeEndState() {
        SagaExecutionState x = new SagaExecutionState();
        x.setEndState(true);
        return x;
    }

    public static SagaExecutionState makeFailedEndState() {
        SagaExecutionState x = new SagaExecutionState();
        x.setEndState(true);
        x.setFailed(true);
        return x;
    }
}

