/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.simpledsl;

import io.eventuate.tram.messaging.common.Message;
import io.eventuate.tram.sagas.orchestration.SagaActions;
import io.eventuate.tram.sagas.orchestration.SagaDefinition;
import io.eventuate.tram.sagas.simpledsl.AbstractSimpleSagaDefinition;
import io.eventuate.tram.sagas.simpledsl.SagaActionsProvider;
import io.eventuate.tram.sagas.simpledsl.SagaExecutionState;
import io.eventuate.tram.sagas.simpledsl.SagaExecutionStateJsonSerde;
import io.eventuate.tram.sagas.simpledsl.SagaStep;
import io.eventuate.tram.sagas.simpledsl.StepToExecute;
import java.util.List;
import java.util.function.Function;

public class SimpleSagaDefinition<Data>
extends AbstractSimpleSagaDefinition<Data, SagaStep<Data>, StepToExecute<Data>, SagaActionsProvider<Data>>
implements SagaDefinition<Data> {
    public SimpleSagaDefinition(List<SagaStep<Data>> steps) {
        super(steps);
    }

    public SagaActions<Data> start(Data sagaData) {
        return this.toSagaActions((SagaActionsProvider)this.firstStepToExecute(sagaData));
    }

    public SagaActions<Data> handleReply(String sagaType, String sagaId, String currentState, Data sagaData, Message message) {
        SagaExecutionState state = SagaExecutionStateJsonSerde.decodeState(currentState);
        SagaStep currentStep = (SagaStep)this.steps.get(state.getCurrentlyExecuting());
        boolean compensating = state.isCompensating();
        currentStep.getReplyHandler(message, compensating).ifPresent(handler -> this.invokeReplyHandler(message, sagaData, (d, m) -> {
            handler.accept(d, m);
            return null;
        }));
        SagaActionsProvider sap = (SagaActionsProvider)this.sagaActionsForNextStep(sagaType, sagaId, sagaData, message, state, currentStep, compensating);
        return this.toSagaActions(sap);
    }

    private SagaActions<Data> toSagaActions(SagaActionsProvider<Data> sap) {
        return (SagaActions)sap.toSagaActions(Function.identity(), Function.identity());
    }

    @Override
    protected SagaActionsProvider<Data> makeSagaActionsProvider(SagaActions<Data> sagaActions) {
        return new SagaActionsProvider<Data>(sagaActions);
    }

    @Override
    protected SagaActionsProvider<Data> makeSagaActionsProvider(StepToExecute<Data> stepToExecute, Data data, SagaExecutionState state) {
        return new SagaActionsProvider(() -> stepToExecute.executeStep(data, state));
    }

    @Override
    protected StepToExecute<Data> makeStepToExecute(int skipped, boolean compensating, SagaStep<Data> step) {
        return new StepToExecute<Data>(step, skipped, compensating);
    }
}

