/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.orchestration;

import io.eventuate.tram.commands.consumer.CommandWithDestination;
import io.eventuate.tram.commands.producer.CommandProducer;
import java.util.HashMap;
import java.util.List;

public class SagaCommandProducer {
    private CommandProducer commandProducer;

    public SagaCommandProducer(CommandProducer commandProducer) {
        this.commandProducer = commandProducer;
    }

    public String sendCommands(String sagaType, String sagaId, List<CommandWithDestination> commands, String sagaReplyChannel) {
        String messageId = null;
        for (CommandWithDestination command : commands) {
            HashMap<String, String> headers = new HashMap<String, String>(command.getExtraHeaders());
            headers.put("command_saga_type", sagaType);
            headers.put("command_saga_id", sagaId);
            messageId = this.commandProducer.send(command.getDestinationChannel(), command.getResource(), command.getCommand(), sagaReplyChannel, headers);
        }
        return messageId;
    }
}

