/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.orchestration;

import io.eventuate.tram.sagas.orchestration.Saga;
import io.eventuate.tram.sagas.orchestration.SagaInstance;
import io.eventuate.tram.sagas.orchestration.SagaManager;
import io.eventuate.tram.sagas.orchestration.SagaManagerFactory;
import io.eventuate.tram.sagas.orchestration.SagaManagerImpl;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaInstanceFactory {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private ConcurrentMap<Saga<?>, SagaManager<?>> sagaManagers = new ConcurrentHashMap();

    public SagaInstanceFactory(SagaManagerFactory sagaManagerFactory, Collection<Saga<?>> sagas) {
        for (Saga<?> saga : sagas) {
            this.sagaManagers.put(saga, this.makeSagaManager(sagaManagerFactory, saga));
        }
    }

    public <SagaData> SagaInstance create(Saga<SagaData> saga, SagaData data) {
        SagaManager sagaManager = (SagaManager)this.sagaManagers.get(saga);
        if (sagaManager == null) {
            throw new RuntimeException("No SagaManager for " + saga);
        }
        return sagaManager.create(data);
    }

    private <SagaData> SagaManager<SagaData> makeSagaManager(SagaManagerFactory sagaManagerFactory, Saga<SagaData> saga) {
        SagaManagerImpl<SagaData> sagaManager = sagaManagerFactory.make(saga);
        sagaManager.subscribeToReplyChannel();
        return sagaManager;
    }
}

