/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.orchestration;

import io.eventuate.common.id.IdGenerator;
import io.eventuate.common.jdbc.EventuateDuplicateKeyException;
import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.common.jdbc.EventuateSchema;
import io.eventuate.tram.sagas.orchestration.DestinationAndResource;
import io.eventuate.tram.sagas.orchestration.JdbcSqlQueryRow;
import io.eventuate.tram.sagas.orchestration.SagaInstance;
import io.eventuate.tram.sagas.orchestration.SagaInstanceRepository;
import io.eventuate.tram.sagas.orchestration.SagaInstanceRepositorySql;
import java.util.HashSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SagaInstanceRepositoryJdbc
implements SagaInstanceRepository {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor;
    private IdGenerator idGenerator;
    private SagaInstanceRepositorySql sagaInstanceRepositorySql;

    public SagaInstanceRepositoryJdbc(EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor, IdGenerator idGenerator, EventuateSchema eventuateSchema) {
        this.eventuateJdbcStatementExecutor = eventuateJdbcStatementExecutor;
        this.idGenerator = idGenerator;
        this.sagaInstanceRepositorySql = new SagaInstanceRepositorySql(eventuateSchema);
    }

    @Override
    public void save(SagaInstance sagaInstance) {
        sagaInstance.setId(this.idGenerator.genId(null).asString());
        this.logger.info("Saving {} {}", (Object)sagaInstance.getSagaType(), (Object)sagaInstance.getId());
        this.eventuateJdbcStatementExecutor.update(this.sagaInstanceRepositorySql.getInsertIntoSagaInstanceSql(), this.sagaInstanceRepositorySql.makeSaveArgs(sagaInstance));
        this.saveDestinationsAndResources(sagaInstance);
    }

    private void saveDestinationsAndResources(SagaInstance sagaInstance) {
        for (DestinationAndResource dr : sagaInstance.getDestinationsAndResources()) {
            try {
                this.eventuateJdbcStatementExecutor.update(this.sagaInstanceRepositorySql.getInsertIntoSagaInstanceParticipantsSql(), new Object[]{sagaInstance.getSagaType(), sagaInstance.getId(), dr.getDestination(), dr.getResource()});
            }
            catch (EventuateDuplicateKeyException e) {
                this.logger.info("key duplicate: sagaType = {}, sagaId = {}, destination = {}, resource = {}", new Object[]{sagaInstance.getSagaType(), sagaInstance.getId(), dr.getDestination(), dr.getResource()});
            }
        }
    }

    @Override
    public SagaInstance find(String sagaType, String sagaId) {
        this.logger.info("finding {} {}", (Object)sagaType, (Object)sagaId);
        HashSet destinationsAndResources = new HashSet(this.eventuateJdbcStatementExecutor.query(this.sagaInstanceRepositorySql.getSelectFromSagaInstanceParticipantsSql(), (rs, rownum) -> new DestinationAndResource(rs.getString("destination"), rs.getString("resource")), new Object[]{sagaType, sagaId}));
        return (SagaInstance)this.eventuateJdbcStatementExecutor.query(this.sagaInstanceRepositorySql.getSelectFromSagaInstanceSql(), (rs, rownum) -> this.sagaInstanceRepositorySql.mapToSagaInstance(sagaType, sagaId, destinationsAndResources, new JdbcSqlQueryRow(rs)), new Object[]{sagaType, sagaId}).stream().findFirst().orElseThrow(() -> new RuntimeException(String.format("Cannot find saga instance %s %s", sagaType, sagaId)));
    }

    @Override
    public void update(SagaInstance sagaInstance) {
        this.logger.info("Updating {} {}", (Object)sagaInstance.getSagaType(), (Object)sagaInstance.getId());
        int count = this.eventuateJdbcStatementExecutor.update(this.sagaInstanceRepositorySql.getUpdateSagaInstanceSql(), this.sagaInstanceRepositorySql.makeUpdateArgs(sagaInstance));
        if (count != 1) {
            throw new RuntimeException("Should be 1 : " + count);
        }
        this.saveDestinationsAndResources(sagaInstance);
    }
}

