/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.orchestration;

import io.eventuate.common.jdbc.EventuateDuplicateKeyException;
import io.eventuate.common.jdbc.EventuateJdbcStatementExecutor;
import io.eventuate.tram.sagas.orchestration.EnlistedAggregate;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnlistedAggregatesDao {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor;

    public EnlistedAggregatesDao(EventuateJdbcStatementExecutor eventuateJdbcStatementExecutor) {
        this.eventuateJdbcStatementExecutor = eventuateJdbcStatementExecutor;
    }

    public void save(String sagaId, Set<EnlistedAggregate> enlistedAggregates) {
        for (EnlistedAggregate ela : enlistedAggregates) {
            try {
                this.eventuateJdbcStatementExecutor.update("INSERT INTO saga_enlisted_aggregates(saga_id, aggregate_type, aggregate_id) values(?,?,?)", new Object[]{sagaId, ela.getAggregateClass(), ela.getAggregateId()});
            }
            catch (EventuateDuplicateKeyException e) {
                this.logger.info("Cannot save aggregate, key duplicate: sagaId = {}, aggregateClass = {}, aggregateId = {}", new Object[]{sagaId, ela.getAggregateClass(), ela.getAggregateId()});
            }
        }
    }

    public Set<EnlistedAggregate> findEnlistedAggregates(String sagaId) {
        return new HashSet<EnlistedAggregate>(this.eventuateJdbcStatementExecutor.query("Select aggregate_type, aggregate_id from saga_enlisted_aggregates where saga_id = ?", (rs, rowNum) -> {
            try {
                return new EnlistedAggregate(ClassUtils.getClass((String)rs.getString("aggregate_type")), rs.getString("aggregate_id"));
            }
            catch (ClassNotFoundException e) {
                this.logger.error("Class not found", (Throwable)e);
                throw new RuntimeException("Class not found", e);
            }
        }, new Object[]{sagaId}));
    }

    public Set<String> findSagas(Class aggregateType, String aggregateId) {
        return new HashSet<String>(this.eventuateJdbcStatementExecutor.query("Select saga_id from saga_enlisted_aggregates where aggregate_type = ? AND  aggregate_id = ?", (rs, rowNum) -> rs.getString("aggregate_type"), new Object[]{aggregateType, aggregateId}));
    }
}

