/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.orchestration;

import io.eventuate.tram.commands.consumer.CommandWithDestination;
import io.eventuate.tram.commands.producer.CommandProducer;
import io.eventuate.tram.sagas.orchestration.CommandWithDestinationAndType;
import io.eventuate.tram.sagas.orchestration.SagaCommandProducer;
import java.util.HashMap;
import java.util.List;

public class SagaCommandProducerImpl
implements SagaCommandProducer {
    private CommandProducer commandProducer;

    public SagaCommandProducerImpl(CommandProducer commandProducer) {
        this.commandProducer = commandProducer;
    }

    @Override
    public String sendCommands(String sagaType, String sagaId, List<CommandWithDestinationAndType> commands, String sagaReplyChannel) {
        String messageId = null;
        for (CommandWithDestinationAndType cwdt : commands) {
            CommandWithDestination command = cwdt.getCommandWithDestination();
            HashMap<String, String> headers = new HashMap<String, String>(command.getExtraHeaders());
            headers.put("command_saga_type", sagaType);
            headers.put("command_saga_id", sagaId);
            if (cwdt.isNotification()) {
                messageId = this.commandProducer.sendNotification(command.getDestinationChannel(), command.getCommand(), headers);
                continue;
            }
            messageId = this.commandProducer.send(command.getDestinationChannel(), command.getResource(), command.getCommand(), sagaReplyChannel, headers);
        }
        return messageId;
    }
}

