/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.testing;

import io.eventuate.common.json.mapper.JSonMapper;
import io.eventuate.tram.commands.common.Command;
import io.eventuate.tram.commands.common.CommandNameMapping;
import io.eventuate.tram.commands.consumer.CommandHandlerReplyBuilder;
import io.eventuate.tram.commands.consumer.CommandMessage;
import io.eventuate.tram.commands.consumer.CommandReplyProducer;
import io.eventuate.tram.messaging.common.Message;
import io.eventuate.tram.messaging.consumer.MessageConsumer;
import io.eventuate.tram.sagas.testing.SagaParticipantChannels;
import io.eventuate.tram.sagas.testing.commandhandling.ReconfigurableCommandHandlers;
import io.eventuate.tram.sagas.testing.commandhandling.SagaParticipantStubCommandHandler;
import io.eventuate.tram.sagas.testing.commandhandling.UnhandledMessageTrackingCommandDispatcher;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class SagaParticipantStubManager {
    private final ReconfigurableCommandHandlers commandHandlers;
    private final Set<String> commandChannels;
    private final UnhandledMessageTrackingCommandDispatcher commandDispatcher;
    private String currentCommandChannel;

    public SagaParticipantStubManager(SagaParticipantChannels sagaParticipantChannels, MessageConsumer messageConsumer, CommandNameMapping commandNameMapping, CommandReplyProducer commandReplyProducer) {
        this.commandChannels = sagaParticipantChannels.getChannels();
        this.commandHandlers = new ReconfigurableCommandHandlers(this.commandChannels);
        this.commandDispatcher = new UnhandledMessageTrackingCommandDispatcher("SagaParticipantStubManager-command-dispatcher-" + System.currentTimeMillis(), this.commandHandlers, messageConsumer, commandNameMapping, commandReplyProducer);
    }

    public void initialize() {
        this.commandDispatcher.initialize();
    }

    public void reset() {
        this.commandHandlers.reset();
        this.commandDispatcher.reset();
    }

    public SagaParticipantStubManager forChannel(String commandChannel) {
        this.validateChannel(commandChannel);
        this.currentCommandChannel = commandChannel;
        return this;
    }

    private void validateChannel(String commandChannel) {
        if (!this.commandChannels.contains(commandChannel)) {
            throw new IllegalArgumentException(String.format("%s is not one of the specified channels: %s", commandChannel, this.commandChannels));
        }
    }

    public <C extends Command> SagaParticipantStubManagerHelper<C> when(C expectedCommand) {
        return new SagaParticipantStubManagerHelper(this, expectedCommand.getClass(), message -> ((Command)JSonMapper.fromJson((String)message.getPayload(), expectedCommand.getClass())).equals(expectedCommand));
    }

    public <C extends Command> SagaParticipantStubManagerHelper<C> when(Class<C> expectedCommandClass) {
        return new SagaParticipantStubManagerHelper<C>(this, expectedCommandClass, message -> true);
    }

    public <C extends Command> void verifyCommandReceived(String channel, Class<C> commandClass) {
        this.commandHandlers.findCommandHandler(channel, commandClass).map(handler -> {
            handler.verifyCommandReceived();
            return true;
        }).orElseThrow(() -> new RuntimeException(String.format("no handler for channel %s command class %s", channel, commandClass)));
    }

    public class SagaParticipantStubManagerHelper<C extends Command> {
        private Class<C> expectedCommandClass;
        private final Predicate<Message> expectedCommand;
        private SagaParticipantStubManager sagaParticipantStubManager;

        public SagaParticipantStubManagerHelper(SagaParticipantStubManager sagaParticipantStubManager, Class<C> expectedCommandClass, Predicate<Message> expectedCommand) {
            this.sagaParticipantStubManager = sagaParticipantStubManager;
            this.expectedCommandClass = expectedCommandClass;
            this.expectedCommand = expectedCommand;
        }

        public SagaParticipantStubManager replyWith(Function<CommandMessage<C>, Message> replyBuilder) {
            SagaParticipantStubCommandHandler<C> commandHandler = new SagaParticipantStubCommandHandler<C>(SagaParticipantStubManager.this.currentCommandChannel, this.expectedCommandClass, this.expectedCommand, replyBuilder);
            this.sagaParticipantStubManager.commandHandlers.add(commandHandler);
            SagaParticipantStubManager.this.commandDispatcher.noteNewCommandHandler(commandHandler);
            return this.sagaParticipantStubManager;
        }

        public SagaParticipantStubManager replyWithSuccess() {
            return this.replyWith(cm -> CommandHandlerReplyBuilder.withSuccess());
        }

        public SagaParticipantStubManager replyWithFailure() {
            return this.replyWith(cm -> CommandHandlerReplyBuilder.withFailure());
        }
    }
}

