/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.testing.commandhandling;

import io.eventuate.tram.commands.common.Command;
import io.eventuate.tram.commands.consumer.CommandHandler;
import io.eventuate.tram.commands.consumer.CommandHandlers;
import io.eventuate.tram.messaging.common.Message;
import io.eventuate.tram.sagas.testing.commandhandling.SagaParticipantStubCommandHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class ReconfigurableCommandHandlers
extends CommandHandlers {
    private final Set<String> commandChannels;
    private List<SagaParticipantStubCommandHandler> handlers = new ArrayList<SagaParticipantStubCommandHandler>();

    public ReconfigurableCommandHandlers(Set<String> commandChannels) {
        super(Collections.emptyList());
        this.commandChannels = commandChannels;
    }

    public Set<String> getChannels() {
        return this.commandChannels;
    }

    public void add(SagaParticipantStubCommandHandler commandHandler) {
        this.handlers.add(commandHandler);
    }

    public Optional<CommandHandler> findTargetMethod(Message message) {
        return this.handlers.stream().filter(h -> h.handles(message)).findFirst().map(x -> x);
    }

    public void reset() {
        this.handlers.clear();
    }

    public <C extends Command> Optional<SagaParticipantStubCommandHandler> findCommandHandler(String channel, Class<C> commandClass) {
        return this.handlers.stream().filter(h -> h.handles(channel, commandClass)).findFirst();
    }
}

