/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.testing.commandhandling;

import io.eventuate.tram.commands.common.Command;
import io.eventuate.tram.commands.consumer.CommandHandler;
import io.eventuate.tram.commands.consumer.CommandHandlerArgs;
import io.eventuate.tram.commands.consumer.CommandMessage;
import io.eventuate.tram.messaging.common.Message;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class SagaParticipantStubCommandHandler<C extends Command>
extends CommandHandler {
    private String commandChannel;
    private final Predicate<Message> expectedCommand;
    private Function<CommandMessage<C>, Message> replyBuilder;
    private final List<CommandMessage<C>> receivedCommands = new ArrayList<CommandMessage<C>>();

    public SagaParticipantStubCommandHandler(String commandChannel, Class<C> expectedCommandClass, Predicate<Message> expectedCommand, Function<CommandMessage<C>, Message> replyBuilder) {
        super(commandChannel, Optional.empty(), expectedCommandClass, args -> null);
        this.commandChannel = commandChannel;
        this.expectedCommand = expectedCommand;
        this.replyBuilder = replyBuilder;
    }

    public List<Message> invokeMethod(CommandHandlerArgs args) {
        CommandMessage cm = args.getCommandMessage();
        this.receivedCommands.add(cm);
        return Collections.singletonList(this.replyBuilder.apply(cm));
    }

    public boolean handles(Message message) {
        return message.getRequiredHeader("DESTINATION").equals(this.commandChannel) && super.handles(message) && this.expectedCommand.test(message);
    }

    public <C extends Command> boolean handles(String channel, Class<C> commandClass) {
        return this.commandChannel.equals(channel) && this.getCommandClass().equals(commandClass);
    }

    public void verifyCommandReceived() {
        if (this.receivedCommands.isEmpty()) {
            throw new RuntimeException("Did not receive command");
        }
    }
}

