/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.tram.sagas.testing.commandhandling;

import io.eventuate.tram.commands.common.Command;
import io.eventuate.tram.commands.common.CommandNameMapping;
import io.eventuate.tram.commands.consumer.CommandDispatcher;
import io.eventuate.tram.commands.consumer.CommandHandlers;
import io.eventuate.tram.commands.consumer.CommandReplyProducer;
import io.eventuate.tram.messaging.common.Message;
import io.eventuate.tram.messaging.consumer.MessageConsumer;
import io.eventuate.tram.sagas.testing.commandhandling.SagaParticipantStubCommandHandler;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnhandledMessageTrackingCommandDispatcher
extends CommandDispatcher {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private CommandHandlers commandHandlers;
    private List<Message> unhandledMessages = new LinkedList<Message>();

    public UnhandledMessageTrackingCommandDispatcher(String commandDispatcherId, CommandHandlers commandHandlers, MessageConsumer messageConsumer, CommandNameMapping commandNameMapping, CommandReplyProducer commandReplyProducer) {
        super(commandDispatcherId, commandHandlers, messageConsumer, commandNameMapping, commandReplyProducer);
        this.commandHandlers = commandHandlers;
    }

    public void messageHandler(Message message) {
        Optional possibleMethod = this.commandHandlers.findTargetMethod(message);
        if (possibleMethod.isPresent()) {
            super.messageHandler(message);
        } else {
            this.logger.info("unhandled message {}", (Object)message);
            this.unhandledMessages.add(message);
        }
    }

    public void reset() {
        this.unhandledMessages.clear();
    }

    public <C extends Command> void noteNewCommandHandler(SagaParticipantStubCommandHandler<C> commandHandler) {
        List<Message> handled = this.unhandledMessages.stream().filter(commandHandler::handles).collect(Collectors.toList());
        if (!handled.isEmpty()) {
            this.logger.info("Processing unhandled messages {}", handled);
        }
        this.unhandledMessages.removeAll(handled);
        handled.forEach(x$0 -> super.messageHandler(x$0));
    }
}

