/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.util.test.async;

import io.eventuate.util.test.async.EventuallyConfig;
import io.eventuate.util.test.async.EventuallyException;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class Eventually {
    public static void setDefaults(EventuallyConfig eventuallyConfig) {
        EventuallyConfig.defaults = eventuallyConfig;
    }

    public static void eventually(Runnable body) {
        Eventually.eventually(EventuallyConfig.defaults, body);
    }

    public static EventuallyConfig.Builder withMessage(String message) {
        return EventuallyConfig.builder().withMessage(message);
    }

    public static EventuallyConfig.Builder withIterations(int iterations) {
        return EventuallyConfig.builder().withIterations(iterations);
    }

    public static EventuallyConfig.Builder withInterval(int timeout, TimeUnit timeUnit) {
        return EventuallyConfig.builder().withInterval(timeout, timeUnit);
    }

    public static void eventually(String message, Runnable body) {
        Eventually.eventually(EventuallyConfig.builder().withMessage(message).build(), body);
    }

    public static void eventually(int iterations, int timeout, TimeUnit timeUnit, Runnable body) {
        Eventually.eventually(null, iterations, timeout, timeUnit, body);
    }

    public static void eventually(String message, int iterations, int timeout, TimeUnit timeUnit, Runnable body) {
        Eventually.eventually(new EventuallyConfig(message, iterations, timeout, timeUnit), body);
    }

    public static void eventually(EventuallyConfig eventuallyConfig, Runnable body) {
        Eventually.eventuallyReturning(eventuallyConfig, () -> {
            body.run();
            return null;
        });
    }

    public static <T> T eventuallyReturning(String message, Supplier<T> body) {
        return Eventually.eventuallyReturning(message, EventuallyConfig.defaults.iterations, EventuallyConfig.defaults.timeout, TimeUnit.MILLISECONDS, body);
    }

    public static <T> T eventuallyReturning(Supplier<T> body) {
        return Eventually.eventuallyReturning(null, EventuallyConfig.defaults.iterations, EventuallyConfig.defaults.timeout, TimeUnit.MILLISECONDS, body);
    }

    public static <T> T eventuallyReturning(int iterations, int timeout, TimeUnit timeUnit, Supplier<T> body) {
        return Eventually.eventuallyReturning(null, iterations, timeout, timeUnit, body);
    }

    public static <T> T eventuallyReturning(String message, int iterations, int timeout, TimeUnit timeUnit, Supplier<T> body) {
        return Eventually.eventuallyReturning(new EventuallyConfig(message, iterations, timeout, timeUnit), body);
    }

    public static <T> T eventuallyReturning(EventuallyConfig eventuallyConfig, Supplier<T> body) {
        Throwable t = null;
        for (int i = 0; i < eventuallyConfig.iterations; ++i) {
            try {
                return body.get();
            }
            catch (Throwable t1) {
                t = t1;
                try {
                    eventuallyConfig.timeUnit.sleep(eventuallyConfig.timeout);
                    continue;
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        if (eventuallyConfig.message == null) {
            throw new EventuallyException(String.format("Failed after %s iterations every %s milliseconds", eventuallyConfig.iterations, eventuallyConfig.timeout), t);
        }
        throw new EventuallyException(String.format(eventuallyConfig.message + " - Failed after %s iterations every %s milliseconds", eventuallyConfig.iterations, eventuallyConfig.timeout), t);
    }
}

