/*
 * Decompiled with CFR 0.152.
 */
package io.eventuate.util.test.async;

import io.eventuate.util.test.async.Eventually;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class EventuallyConfig {
    public final String message;
    public final int iterations;
    public final int timeout;
    public final TimeUnit timeUnit;
    public static EventuallyConfig defaults = EventuallyConfig.builder().build();

    public EventuallyConfig(String message, int iterations, int timeout, TimeUnit timeUnit) {
        this.message = message;
        this.iterations = iterations;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String message = null;
        private int iterations = Optional.ofNullable(System.getenv("EVENTUATE_TEST_UTIL_DEFAULT_ITERATIONS")).map(Integer::parseInt).orElse(20);
        private int timeout = Optional.ofNullable(System.getenv("EVENTUATE_TEST_UTIL_DEFAULT_INTERVAL_IN_MILLIS")).map(Integer::parseInt).orElse(500);
        private TimeUnit timeUnit = TimeUnit.MILLISECONDS;

        public Builder withMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder withIterations(int iterations) {
            this.iterations = iterations;
            return this;
        }

        public Builder withInterval(int timeout, TimeUnit timeUnit) {
            this.timeout = timeout;
            this.timeUnit = timeUnit;
            return this;
        }

        public EventuallyConfig build() {
            return new EventuallyConfig(this.message, this.iterations, this.timeout, this.timeUnit);
        }

        public void eventually(Runnable body) {
            Eventually.eventually(this.build(), body);
        }

        public <T> T eventuallyReturningValue(Supplier<T> body) {
            return Eventually.eventuallyReturning(this.build(), body);
        }
    }
}

