/*
 * Decompiled with CFR 0.152.
 */
package io.extremum.signaler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import io.extremum.sharedmodels.constant.HttpStatus;
import io.extremum.sharedmodels.signal.Signal;
import io.extremum.sharedmodels.signal.SignalKind;
import io.extremum.sharedmodels.signal.SubscriptionRequest;
import io.extremum.signaler.SignalerException;
import io.extremum.signaler.SignalerOperations;
import io.extremum.signaler.SignalerPublisherProperties;
import java.io.Closeable;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000bJ)\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\nH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0012J?\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\n2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J?\u0010\u0016\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0014H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lio/extremum/signaler/SignalerTemplate;", "Lio/extremum/signaler/SignalerOperations;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "signalerProperties", "Lio/extremum/signaler/SignalerPublisherProperties;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Lio/extremum/signaler/SignalerPublisherProperties;)V", "poll", "Lio/extremum/sharedmodels/dto/Response;", "subscriptionId", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "send", "", "data", "", "exchange", "source", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "headers", "", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "subscribe", "destination", "function", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Map;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "signaler"})
public final class SignalerTemplate
implements SignalerOperations {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final SignalerPublisherProperties signalerProperties;
    @Deprecated
    @NotNull
    private static final OkHttpClient httpClient = new OkHttpClient();

    public SignalerTemplate(@NotNull ObjectMapper objectMapper, @NotNull SignalerPublisherProperties signalerProperties) {
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)signalerProperties, (String)"signalerProperties");
        this.objectMapper = objectMapper;
        this.signalerProperties = signalerProperties;
    }

    @Override
    @Nullable
    public Object send(@NotNull Object data, @NotNull String exchange, @NotNull String source, @NotNull Continuation<? super Unit> $completion) {
        Object object = this.send(data, exchange, source, this.signalerProperties.getHeaders(), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    public Object send(@NotNull Object data, @NotNull String exchange, @NotNull String source, @Nullable Map<String, String> headers, @NotNull Continuation<? super Unit> $completion) {
        Request.Builder builder;
        Signal signal;
        Signal $this$send_u24lambda_u2d0 = signal = new Signal(SignalKind.REGULAR, exchange, source);
        boolean bl = false;
        $this$send_u24lambda_u2d0.setData(data);
        Signal signal2 = signal;
        Request.Builder $this$send_u24lambda_u2d2 = builder = new Request.Builder().url(this.signalerProperties.getEndpoint()).post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.objectMapper.writeValueAsString((Object)signal2)));
        boolean bl2 = false;
        Map<String, String> map = headers;
        if (map != null) {
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = iterator.next();
                boolean bl3 = false;
                String header = entry.getKey();
                String value = entry.getValue();
                $this$send_u24lambda_u2d2.header(header, value);
            }
        }
        Request request = builder.build();
        int it = httpClient.newCall(request).execute().code();
        boolean bl4 = false;
        if (it != HttpStatus.OK.value()) {
            throw new SignalerException("Unable to send signal to " + exchange);
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public Object subscribe(@NotNull String exchange, @NotNull String destination, @NotNull String function, @Nullable Map<String, String> headers, @NotNull Continuation<? super String> $completion) {
        Object object;
        Request.Builder builder;
        SubscriptionRequest subscriptionRequest = new SubscriptionRequest(destination, function);
        Request.Builder $this$subscribe_u24lambda_u2d5 = builder = new Request.Builder().url(this.signalerProperties.getEndpoint() + "/exchanges/" + exchange + "/sub").post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.objectMapper.writeValueAsString((Object)subscriptionRequest)));
        boolean bl = false;
        Map<String, String> map = headers;
        if (map != null) {
            Map<String, String> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry<String, String> element$iv;
                Map.Entry<String, String> entry = element$iv = object.next();
                boolean bl2 = false;
                String header = entry.getKey();
                String value = entry.getValue();
                $this$subscribe_u24lambda_u2d5.header(header, value);
            }
        }
        Request request = builder.build();
        Response it = httpClient.newCall(request).execute();
        boolean bl3 = false;
        if (it.code() != HttpStatus.OK.value()) {
            throw new SignalerException("Unable to subscribe function " + function + " to " + exchange);
        }
        Closeable closeable = (Closeable)it.body();
        Throwable throwable = null;
        try {
            ResponseBody body = (ResponseBody)closeable;
            boolean bl4 = false;
            io.extremum.sharedmodels.dto.Response readValue = (io.extremum.sharedmodels.dto.Response)this.objectMapper.readValue(body.string(), io.extremum.sharedmodels.dto.Response.class);
            Object result = readValue.getResult();
            if (!(result instanceof String)) {
                throw new SignalerException("Wrong response body");
            }
            object = (String)result;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return object;
    }

    @Override
    @Nullable
    public Object poll(@NotNull String subscriptionId, @NotNull Continuation<? super io.extremum.sharedmodels.dto.Response> $completion) {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/extremum/signaler/SignalerTemplate$Companion;", "", "()V", "httpClient", "Lcom/squareup/okhttp/OkHttpClient;", "getHttpClient", "()Lcom/squareup/okhttp/OkHttpClient;", "signaler"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final OkHttpClient getHttpClient() {
            return httpClient;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

