/*
 * Decompiled with CFR 0.152.
 */
package io.ezto.verify.sdk.service;

import android.util.Base64;
import androidx.compose.runtime.internal.StabilityInferred;
import io.ezto.verify.sdk.exceptions.EncryptionKeyException;
import java.security.MessageDigest;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.spongycastle.asn1.x509.SubjectPublicKeyInfo;
import org.spongycastle.crypto.AsymmetricBlockCipher;
import org.spongycastle.crypto.BlockCipher;
import org.spongycastle.crypto.CipherParameters;
import org.spongycastle.crypto.encodings.OAEPEncoding;
import org.spongycastle.crypto.engines.AESEngine;
import org.spongycastle.crypto.engines.RSAEngine;
import org.spongycastle.crypto.paddings.BlockCipherPadding;
import org.spongycastle.crypto.paddings.PKCS7Padding;
import org.spongycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.spongycastle.crypto.params.AsymmetricKeyParameter;
import org.spongycastle.crypto.params.KeyParameter;
import org.spongycastle.crypto.params.RSAKeyParameters;
import org.spongycastle.crypto.util.PublicKeyFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004J\u0016\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lio/ezto/verify/sdk/service/EncryptionService;", "", "()V", "decryptPushWithAes", "", "key", "cipherText", "encryptWithRsa", "publicKey", "challenge", "toSha256Hash", "", "dataToDigest", "sdk_release"})
@StabilityInferred(parameters=0)
public final class EncryptionService {
    public static final int $stable;

    @NotNull
    public final String encryptWithRsa(@NotNull String publicKey, @NotNull String challenge) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)challenge, (String)"challenge");
        try {
            byte[] keyBytes = Base64.decode((String)publicKey, (int)0);
            byte[] dataToEncrypt = Base64.decode((String)challenge, (int)0);
            SubjectPublicKeyInfo keySpec = SubjectPublicKeyInfo.getInstance((Object)keyBytes);
            AsymmetricKeyParameter asymmetricKeyParameter = PublicKeyFactory.createKey((SubjectPublicKeyInfo)keySpec);
            Intrinsics.checkNotNull((Object)asymmetricKeyParameter, (String)"null cannot be cast to non-null type org.spongycastle.crypto.params.RSAKeyParameters");
            RSAKeyParameters rsaPublicKey = (RSAKeyParameters)asymmetricKeyParameter;
            AsymmetricBlockCipher encryptor = (AsymmetricBlockCipher)new OAEPEncoding((AsymmetricBlockCipher)new RSAEngine());
            encryptor.init(true, (CipherParameters)rsaPublicKey);
            byte[] encryptedBytes = encryptor.processBlock(dataToEncrypt, 0, dataToEncrypt.length);
            String string = Base64.encodeToString((byte[])encryptedBytes, (int)2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encodeToString(encrypted\u2026EFAULT or Base64.NO_WRAP)");
            return string;
        }
        catch (Exception e) {
            throw new EncryptionKeyException(e);
        }
    }

    @NotNull
    public final String decryptPushWithAes(@NotNull String key, @NotNull String cipherText) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)cipherText, (String)"cipherText");
        try {
            byte[] keyBytes = Base64.decode((String)key, (int)0);
            byte[] dataToDecrypt = Base64.decode((String)cipherText, (int)0);
            BlockCipher aesEngine = (BlockCipher)new AESEngine();
            PaddedBufferedBlockCipher paddedCipher = new PaddedBufferedBlockCipher(aesEngine, (BlockCipherPadding)new PKCS7Padding());
            paddedCipher.init(false, (CipherParameters)new KeyParameter(keyBytes));
            byte[] decryptedBytes = new byte[paddedCipher.getOutputSize(dataToDecrypt.length)];
            int len = paddedCipher.processBytes(dataToDecrypt, 0, dataToDecrypt.length, decryptedBytes, 0);
            int finalLen = len + paddedCipher.doFinal(decryptedBytes, len);
            byte[] byArray = Arrays.copyOf(decryptedBytes, finalLen);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(...)");
            byte[] finalDecryptedBytes = byArray;
            return new String(finalDecryptedBytes, Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new EncryptionKeyException(e);
        }
    }

    @NotNull
    public final byte[] toSha256Hash(@NotNull byte[] dataToDigest) {
        Intrinsics.checkNotNullParameter((Object)dataToDigest, (String)"dataToDigest");
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        byte[] byArray = sha256.digest(dataToDigest);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sha256.digest(dataToDigest)");
        return byArray;
    }
}

