/*
 * Decompiled with CFR 0.152.
 */
package io.ezto.verify.sdk.service;

import android.content.Context;
import android.content.SharedPreferences;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.security.crypto.EncryptedSharedPreferences;
import io.ezto.verify.sdk.model.PublicKeyModel;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lio/ezto/verify/sdk/service/StorageService;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "sharedPreferences", "Landroid/content/SharedPreferences;", "getOrCreateDeviceId", "", "isFirstRun", "", "readBioPublicKey", "Lio/ezto/verify/sdk/model/PublicKeyModel;", "writeBioPublicKey", "", "publicKey", "credentialId", "sdk_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nStorageService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StorageService.kt\nio/ezto/verify/sdk/service/StorageService\n+ 2 SharedPreferences.kt\nandroidx/core/content/SharedPreferencesKt\n*L\n1#1,62:1\n39#2,12:63\n*S KotlinDebug\n*F\n+ 1 StorageService.kt\nio/ezto/verify/sdk/service/StorageService\n*L\n43#1:63,12\n*E\n"})
public final class StorageService {
    @NotNull
    private final Context context;
    @NotNull
    private SharedPreferences sharedPreferences;
    public static final int $stable = 8;

    public StorageService(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        SharedPreferences sharedPreferences = EncryptedSharedPreferences.create((String)"qlikverify_sdk", (String)"secret_shared_prefs", (Context)this.context, (EncryptedSharedPreferences.PrefKeyEncryptionScheme)EncryptedSharedPreferences.PrefKeyEncryptionScheme.AES256_SIV, (EncryptedSharedPreferences.PrefValueEncryptionScheme)EncryptedSharedPreferences.PrefValueEncryptionScheme.AES256_GCM);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"create(\n        \"qlikver\u2026\n        AES256_GCM\n    )");
        this.sharedPreferences = sharedPreferences;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    public final void writeBioPublicKey(@NotNull String publicKey, @NotNull String credentialId) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)credentialId, (String)"credentialId");
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"sharedPreferences.edit()");
        SharedPreferences.Editor editor2 = editor;
        editor2.putString("bio_public_key", publicKey);
        editor2.putString("bio_public_cred_id", credentialId);
        editor2.apply();
    }

    @Nullable
    public final PublicKeyModel readBioPublicKey() {
        String publicKey = this.sharedPreferences.getString("bio_public_key", "");
        String credId = this.sharedPreferences.getString("bio_public_cred_id", "");
        if (publicKey == null || credId == null) {
            return null;
        }
        return new PublicKeyModel(publicKey, credId);
    }

    @NotNull
    public final String getOrCreateDeviceId() {
        String uuid = this.sharedPreferences.getString("device_id", null);
        if (uuid == null) {
            SharedPreferences.Editor editor$iv;
            UUID myUuid = UUID.randomUUID();
            SharedPreferences $this$edit_u24default$iv = this.sharedPreferences;
            boolean commit$iv = false;
            boolean $i$f$edit = false;
            SharedPreferences.Editor $this$getOrCreateDeviceId_u24lambda_u240 = editor$iv = $this$edit_u24default$iv.edit();
            boolean bl = false;
            $this$getOrCreateDeviceId_u24lambda_u240.putString("device_id", myUuid.toString());
            $this$getOrCreateDeviceId_u24lambda_u240.apply();
            editor$iv.apply();
            uuid = myUuid.toString();
        }
        return uuid;
    }

    public final boolean isFirstRun() {
        boolean isFirstRun = this.sharedPreferences.getBoolean("is_first_run", true);
        if (isFirstRun) {
            SharedPreferences.Editor $this$isFirstRun_u24lambda_u241 = this.sharedPreferences.edit();
            boolean bl = false;
            $this$isFirstRun_u24lambda_u241.putBoolean("is_first_run", false);
            $this$isFirstRun_u24lambda_u241.apply();
        }
        return isFirstRun;
    }
}

