/*
 * Decompiled with CFR 0.152.
 */
package io.ezto.verify.sdk;

import android.media.Image;
import androidx.camera.core.ExperimentalGetImage;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.compose.runtime.internal.StabilityInferred;
import com.google.mlkit.vision.barcode.BarcodeScanner;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.common.InputImage;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B(\u0012!\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017R,\u0010\u0002\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lio/ezto/verify/sdk/BarcodeAnalyser;", "Landroidx/camera/core/ImageAnalysis$Analyzer;", "callback", "Lkotlin/Function1;", "Lcom/google/mlkit/vision/barcode/common/Barcode;", "Lkotlin/ParameterName;", "name", "barcode", "", "(Lkotlin/jvm/functions/Function1;)V", "getCallback", "()Lkotlin/jvm/functions/Function1;", "scannedOnce", "", "analyze", "imageProxy", "Landroidx/camera/core/ImageProxy;", "sdk_release"})
@StabilityInferred(parameters=0)
public final class BarcodeAnalyser
implements ImageAnalysis.Analyzer {
    @NotNull
    private final Function1<Barcode, Unit> callback;
    private boolean scannedOnce;
    public static final int $stable = 8;

    public BarcodeAnalyser(@NotNull Function1<? super Barcode, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.callback = callback;
    }

    @NotNull
    public final Function1<Barcode, Unit> getCallback() {
        return this.callback;
    }

    @ExperimentalGetImage
    public void analyze(@NotNull ImageProxy imageProxy) {
        Image mediaImage;
        Intrinsics.checkNotNullParameter((Object)imageProxy, (String)"imageProxy");
        BarcodeScannerOptions barcodeScannerOptions = new BarcodeScannerOptions.Builder().setBarcodeFormats(256, new int[0]).build();
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScannerOptions, (String)"Builder()\n            .s\u2026ODE)\n            .build()");
        BarcodeScannerOptions options = barcodeScannerOptions;
        BarcodeScanner barcodeScanner = BarcodeScanning.getClient((BarcodeScannerOptions)options);
        Intrinsics.checkNotNullExpressionValue((Object)barcodeScanner, (String)"getClient(options)");
        BarcodeScanner scanner = barcodeScanner;
        Image image = mediaImage = imageProxy.getImage();
        if (image != null) {
            Image it = image;
            boolean bl = false;
            InputImage inputImage = InputImage.fromMediaImage((Image)mediaImage, (int)imageProxy.getImageInfo().getRotationDegrees());
            Intrinsics.checkNotNullExpressionValue((Object)inputImage, (String)"fromMediaImage(mediaImag\u2026mageInfo.rotationDegrees)");
            InputImage image2 = inputImage;
            scanner.process(image2).addOnSuccessListener(arg_0 -> BarcodeAnalyser.analyze$lambda$2$lambda$0((Function1)new Function1<List<Barcode>, Unit>(this){
                final /* synthetic */ BarcodeAnalyser this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(List<Barcode> barcodes) {
                    if (barcodes.size() > 0 && !BarcodeAnalyser.access$getScannedOnce$p(this.this$0)) {
                        BarcodeAnalyser.access$setScannedOnce$p(this.this$0, true);
                        Function1<Barcode, Unit> function1 = this.this$0.getCallback();
                        Intrinsics.checkNotNullExpressionValue(barcodes, (String)"barcodes");
                        Object object = CollectionsKt.first(barcodes);
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"barcodes.first()");
                        function1.invoke(object);
                    }
                }
            }, arg_0)).addOnFailureListener(BarcodeAnalyser::analyze$lambda$2$lambda$1);
        }
        imageProxy.close();
    }

    private static final void analyze$lambda$2$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void analyze$lambda$2$lambda$1(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
    }

    public static final /* synthetic */ boolean access$getScannedOnce$p(BarcodeAnalyser $this) {
        return $this.scannedOnce;
    }

    public static final /* synthetic */ void access$setScannedOnce$p(BarcodeAnalyser $this, boolean bl) {
        $this.scannedOnce = bl;
    }
}

