/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.io.prometheus.client;

import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class CollectorRegistry {
    public static final CollectorRegistry defaultRegistry = new CollectorRegistry(true);
    private final Map<Collector, List<String>> collectorsToNames = new HashMap<Collector, List<String>>();
    private final Map<String, Collector> namesToCollectors = new HashMap<String, Collector>();
    private final boolean autoDescribe;

    public CollectorRegistry() {
        this(false);
    }

    public CollectorRegistry(boolean autoDescribe) {
        this.autoDescribe = autoDescribe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Collector m) {
        List<String> names = this.collectorNames(m);
        Map<Collector, List<String>> map = this.collectorsToNames;
        synchronized (map) {
            for (String name : names) {
                if (!this.namesToCollectors.containsKey(name)) continue;
                throw new IllegalArgumentException("Collector already registered that provides name: " + name);
            }
            for (String name : names) {
                this.namesToCollectors.put(name, m);
            }
            this.collectorsToNames.put(m, names);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Collector m) {
        Map<Collector, List<String>> map = this.collectorsToNames;
        synchronized (map) {
            for (String name : this.collectorsToNames.get(m)) {
                this.namesToCollectors.remove(name);
            }
            this.collectorsToNames.remove(m);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<Collector, List<String>> map = this.collectorsToNames;
        synchronized (map) {
            this.collectorsToNames.clear();
            this.namesToCollectors.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Collector> collectors() {
        Map<Collector, List<String>> map = this.collectorsToNames;
        synchronized (map) {
            return new HashSet<Collector>(this.collectorsToNames.keySet());
        }
    }

    private List<String> collectorNames(Collector m) {
        List<Collector.MetricFamilySamples> mfs = m instanceof Collector.Describable ? ((Collector.Describable)((Object)m)).describe() : (this.autoDescribe ? m.collect() : Collections.emptyList());
        ArrayList<String> names = new ArrayList<String>();
        for (Collector.MetricFamilySamples family : mfs) {
            switch (family.type) {
                case SUMMARY: {
                    names.add(family.name + "_count");
                    names.add(family.name + "_sum");
                    names.add(family.name);
                }
                case HISTOGRAM: {
                    names.add(family.name + "_count");
                    names.add(family.name + "_sum");
                    names.add(family.name + "_bucket");
                }
            }
            names.add(family.name);
        }
        return names;
    }

    public Enumeration<Collector.MetricFamilySamples> metricFamilySamples() {
        return new MetricFamilySamplesEnumeration();
    }

    public Double getSampleValue(String name) {
        return this.getSampleValue(name, new String[0], new String[0]);
    }

    public Double getSampleValue(String name, String[] labelNames, String[] labelValues) {
        for (Collector.MetricFamilySamples metricFamilySamples : Collections.list(this.metricFamilySamples())) {
            for (Collector.MetricFamilySamples.Sample sample : metricFamilySamples.samples) {
                if (!sample.name.equals(name) || !Arrays.equals(sample.labelNames.toArray(), labelNames) || !Arrays.equals(sample.labelValues.toArray(), labelValues)) continue;
                return sample.value;
            }
        }
        return null;
    }

    class MetricFamilySamplesEnumeration
    implements Enumeration<Collector.MetricFamilySamples> {
        private final Iterator<Collector> collectorIter;
        private Iterator<Collector.MetricFamilySamples> metricFamilySamples;
        private Collector.MetricFamilySamples next;

        MetricFamilySamplesEnumeration() {
            this.collectorIter = CollectorRegistry.this.collectors().iterator();
            this.findNextElement();
        }

        private void findNextElement() {
            if (this.metricFamilySamples != null && this.metricFamilySamples.hasNext()) {
                this.next = this.metricFamilySamples.next();
            } else {
                while (this.collectorIter.hasNext()) {
                    this.metricFamilySamples = this.collectorIter.next().collect().iterator();
                    if (!this.metricFamilySamples.hasNext()) continue;
                    this.next = this.metricFamilySamples.next();
                    return;
                }
                this.next = null;
            }
        }

        @Override
        public Collector.MetricFamilySamples nextElement() {
            Collector.MetricFamilySamples current = this.next;
            if (current == null) {
                throw new NoSuchElementException();
            }
            this.findNextElement();
            return current;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next != null;
        }
    }
}

