/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.security.authentication;

import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.javax.servlet.ServletRequest;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.javax.servlet.ServletResponse;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.javax.servlet.http.HttpServletRequest;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.javax.servlet.http.HttpServletResponse;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.security.ServerAuthException;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.security.UserAuthentication;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.security.authentication.DeferredAuthentication;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.security.authentication.LoginAuthenticator;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.server.Authentication;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.server.UserIdentity;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.util.B64Code;
import java.io.IOException;

public class BasicAuthenticator
extends LoginAuthenticator {
    @Override
    public String getAuthMethod() {
        return "BASIC";
    }

    @Override
    public Authentication validateRequest(ServletRequest req, ServletResponse res, boolean mandatory) throws ServerAuthException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String credentials = request.getHeader("Authorization");
        try {
            String method;
            int space;
            if (!mandatory) {
                return this._deferred;
            }
            if (credentials != null && (space = credentials.indexOf(32)) > 0 && "basic".equalsIgnoreCase(method = credentials.substring(0, space))) {
                String password;
                String username;
                UserIdentity user;
                credentials = credentials.substring(space + 1);
                int i = (credentials = B64Code.decode(credentials, "ISO-8859-1")).indexOf(58);
                if (i > 0 && (user = this._loginService.login(username = credentials.substring(0, i), password = credentials.substring(i + 1))) != null) {
                    this.renewSession(request, response);
                    return new UserAuthentication(this.getAuthMethod(), user);
                }
            }
            if (DeferredAuthentication.isDeferred(response)) {
                return Authentication.UNAUTHENTICATED;
            }
            response.setHeader("WWW-Authenticate", "basic realm=\"" + this._loginService.getName() + '\"');
            response.sendError(401);
            return Authentication.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new ServerAuthException(e);
        }
    }

    @Override
    public boolean secureResponse(ServletRequest req, ServletResponse res, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException {
        return true;
    }
}

