/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.server.handler;

import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.javax.servlet.ServletException;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.javax.servlet.http.HttpServletRequest;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.javax.servlet.http.HttpServletResponse;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.http.PathMap;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.server.AsyncContinuation;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.server.Handler;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.server.HandlerContainer;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.server.Request;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.server.handler.ContextHandler;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.server.handler.HandlerCollection;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.util.LazyList;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.util.log.Log;
import io.fabric8.agent.shaded.jmx_exporter.io.prometheus.jmx.shaded.org.eclipse.jetty.util.log.Logger;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ContextHandlerCollection
extends HandlerCollection {
    private static final Logger LOG = Log.getLogger(ContextHandlerCollection.class);
    private volatile PathMap _contextMap;
    private Class<? extends ContextHandler> _contextClass = ContextHandler.class;

    public ContextHandlerCollection() {
        super(true);
    }

    public void mapContexts() {
        PathMap contextMap = new PathMap();
        Handler[] branches = this.getHandlers();
        for (int b = 0; branches != null && b < branches.length; ++b) {
            Handler[] handlers = null;
            if (branches[b] instanceof ContextHandler) {
                handlers = new Handler[]{branches[b]};
            } else {
                if (!(branches[b] instanceof HandlerContainer)) continue;
                handlers = ((HandlerContainer)((Object)branches[b])).getChildHandlersByClass(ContextHandler.class);
            }
            for (int i = 0; i < handlers.length; ++i) {
                HashMap hosts;
                ContextHandler handler = (ContextHandler)handlers[i];
                String contextPath = handler.getContextPath();
                if (contextPath == null || contextPath.indexOf(44) >= 0 || contextPath.startsWith("*")) {
                    throw new IllegalArgumentException("Illegal context spec:" + contextPath);
                }
                if (!contextPath.startsWith("/")) {
                    contextPath = '/' + contextPath;
                }
                if (contextPath.length() > 1) {
                    if (contextPath.endsWith("/")) {
                        contextPath = contextPath + "*";
                    } else if (!contextPath.endsWith("/*")) {
                        contextPath = contextPath + "/*";
                    }
                }
                Object contexts = contextMap.get(contextPath);
                String[] vhosts = handler.getVirtualHosts();
                if (vhosts != null && vhosts.length > 0) {
                    if (contexts instanceof Map) {
                        hosts = (Map)contexts;
                    } else {
                        hosts = new HashMap();
                        hosts.put("*", contexts);
                        contextMap.put(contextPath, hosts);
                    }
                    for (int j = 0; j < vhosts.length; ++j) {
                        String vhost = vhosts[j];
                        contexts = hosts.get(vhost);
                        contexts = LazyList.add(contexts, branches[b]);
                        hosts.put(vhost, contexts);
                    }
                    continue;
                }
                if (contexts instanceof Map) {
                    hosts = (HashMap)contexts;
                    contexts = hosts.get("*");
                    contexts = LazyList.add(contexts, branches[b]);
                    hosts.put("*", contexts);
                    continue;
                }
                contexts = LazyList.add(contexts, branches[b]);
                contextMap.put(contextPath, contexts);
            }
        }
        this._contextMap = contextMap;
    }

    @Override
    public void setHandlers(Handler[] handlers) {
        this._contextMap = null;
        super.setHandlers(handlers);
        if (this.isStarted()) {
            this.mapContexts();
        }
    }

    @Override
    protected void doStart() throws Exception {
        this.mapContexts();
        super.doStart();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ContextHandler context;
        Handler[] handlers = this.getHandlers();
        if (handlers == null || handlers.length == 0) {
            return;
        }
        AsyncContinuation async = baseRequest.getAsyncContinuation();
        if (async.isAsync() && (context = async.getContextHandler()) != null) {
            context.handle(target, baseRequest, request, response);
            return;
        }
        PathMap map = this._contextMap;
        if (map != null && target != null && target.startsWith("/")) {
            Object contexts = map.getLazyMatches(target);
            for (int i = 0; i < LazyList.size(contexts); ++i) {
                Map.Entry entry = (Map.Entry)LazyList.get(contexts, i);
                Object list = entry.getValue();
                if (list instanceof Map) {
                    Handler handler;
                    int j;
                    Map hosts = (Map)list;
                    String host = this.normalizeHostname(request.getServerName());
                    list = hosts.get(host);
                    for (j = 0; j < LazyList.size(list); ++j) {
                        handler = (Handler)LazyList.get(list, j);
                        handler.handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                    list = hosts.get("*." + host.substring(host.indexOf(".") + 1));
                    for (j = 0; j < LazyList.size(list); ++j) {
                        handler = (Handler)LazyList.get(list, j);
                        handler.handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                    list = hosts.get("*");
                    for (j = 0; j < LazyList.size(list); ++j) {
                        handler = (Handler)LazyList.get(list, j);
                        handler.handle(target, baseRequest, request, response);
                        if (!baseRequest.isHandled()) continue;
                        return;
                    }
                    continue;
                }
                for (int j = 0; j < LazyList.size(list); ++j) {
                    Handler handler = (Handler)LazyList.get(list, j);
                    handler.handle(target, baseRequest, request, response);
                    if (!baseRequest.isHandled()) continue;
                    return;
                }
            }
        } else {
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].handle(target, baseRequest, request, response);
                if (!baseRequest.isHandled()) continue;
                return;
            }
        }
    }

    public ContextHandler addContext(String contextPath, String resourceBase) {
        try {
            ContextHandler context = this._contextClass.newInstance();
            context.setContextPath(contextPath);
            context.setResourceBase(resourceBase);
            this.addHandler(context);
            return context;
        }
        catch (Exception e) {
            LOG.debug(e);
            throw new Error(e);
        }
    }

    public Class getContextClass() {
        return this._contextClass;
    }

    public void setContextClass(Class contextClass) {
        if (contextClass == null || !ContextHandler.class.isAssignableFrom(contextClass)) {
            throw new IllegalArgumentException();
        }
        this._contextClass = contextClass;
    }

    private String normalizeHostname(String host) {
        if (host == null) {
            return null;
        }
        if (host.endsWith(".")) {
            return host.substring(0, host.length() - 1);
        }
        return host;
    }
}

