/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.bond.agent;

import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AgentConfiguration {
    private Properties arguments;
    private HashMap<Object, Object> agentCliArgs;

    public AgentConfiguration(Set<String> agents, String args) {
        String remaining = this.extractAgentArgs(agents, args == null ? "" : args);
        String propFile = this.extractPropertyFile(remaining);
        this.arguments = this.loadProperties(propFile);
        this.arguments.putAll((Map<?, ?>)this.agentCliArgs);
    }

    private String extractPropertyFile(String remaining) {
        StringTokenizer tok = new StringTokenizer(remaining, ",");
        ArrayList<String> propFiles = new ArrayList<String>();
        while (tok.hasMoreTokens()) {
            propFiles.add(tok.nextToken());
        }
        if (propFiles.size() == 0) {
            return null;
        }
        if (propFiles.size() > 1) {
            throw new IllegalArgumentException("More than one property file declared: " + remaining);
        }
        return (String)propFiles.get(0);
    }

    private Properties loadProperties(String propFile) {
        Properties ret = new Properties();
        Properties prop = this.extractProperties(propFile);
        if (prop != null) {
            ret.putAll((Map<?, ?>)prop);
        }
        return ret;
    }

    private String extractAgentArgs(Set<String> agents, String args) {
        this.agentCliArgs = new HashMap();
        Pattern splitPattern = Pattern.compile("(?:^|,)\\s*([^,{]+)\\{{2}(.*?)}{2}\\s*");
        Matcher matcher = splitPattern.matcher(args);
        StringBuffer rest = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(rest, "");
            String agent = matcher.group(1);
            String agentArgs = matcher.group(2);
            if (!agents.contains(agent)) {
                throw new IllegalArgumentException("No agent '" + agent + "' available from [" + agents + "]");
            }
            this.agentCliArgs.put(agent, agentArgs);
        }
        matcher.appendTail(rest);
        return rest.toString();
    }

    public String getArgs(String agentId) {
        return this.arguments.getProperty(agentId);
    }

    private Properties extractProperties(String propertyFile) {
        Properties ret = new Properties();
        if (propertyFile != null) {
            try {
                FileReader reader = new FileReader(propertyFile);
                ret.load(reader);
                reader.close();
            }
            catch (FileNotFoundException e) {
                throw new IllegalArgumentException("No property file " + propertyFile + " found", e);
            }
            catch (IOException e) {
                throw new RuntimeException("Can not read " + propertyFile + ": " + e, e);
            }
        }
        return ret;
    }
}

