/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.utils.Strings;
import io.fabric8.utils.Systems;
import java.net.URL;
import java.util.Map;

public class Configuration {
    private String masterUrl;
    private URL configUrl;
    private long timeout = 300000L;
    private long pollInterval = 5000L;
    private boolean ansiLoggerEnabled = true;

    public String getMasterUrl() {
        return this.masterUrl;
    }

    public URL getConfigUrl() {
        return this.configUrl;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public long getPollInterval() {
        return this.pollInterval;
    }

    public boolean isAnsiLoggerEnabled() {
        return this.ansiLoggerEnabled;
    }

    public static Configuration fromMap(Map<String, String> map) {
        Configuration configuration = new Configuration();
        try {
            configuration.masterUrl = map.containsKey("masterUrl") ? map.get("masterUrl") : Systems.getEnvVarOrSystemProperty((String)"KUBERNETES_MASTER", (String)"");
            if (Strings.isNullOrBlank((String)configuration.getMasterUrl())) {
                throw new IllegalStateException("Could not find a valid kubernetes URL.");
            }
            configuration.configUrl = map.containsKey("configUrl") ? new URL(map.get("configUrl")) : (map.containsKey("configFileName") ? Configuration.class.getResource("/" + map.get("configFileName")) : Configuration.class.getResource("/kubernetes.json"));
            if (map.containsKey("timeout")) {
                configuration.timeout = Long.parseLong(map.get("timeout"));
            }
            if (map.containsKey("pollInterval")) {
                configuration.pollInterval = Long.parseLong(map.get("pollInterval"));
            }
            configuration.ansiLoggerEnabled = map.containsKey("ansi.logger.enabled") ? Boolean.parseBoolean(map.get("ansi.logger.enabled")) : Systems.getEnvVarOrSystemProperty((String)"ansi.logger.enabled", (Boolean)true);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return configuration;
    }
}

