/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes;

import io.fabric8.arquillian.kubernetes.Configuration;
import io.fabric8.arquillian.kubernetes.await.SessionPodsAreReady;
import io.fabric8.arquillian.kubernetes.await.WaitStrategy;
import io.fabric8.arquillian.kubernetes.event.Start;
import io.fabric8.arquillian.kubernetes.event.Stop;
import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.arquillian.utils.Util;
import io.fabric8.kubernetes.api.Config;
import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import java.util.HashMap;
import org.jboss.arquillian.core.api.annotation.Observes;

public class SessionListener {
    public void start(@Observes Start event, KubernetesClient client, Controller controller, Configuration configuration) {
        boolean shouldWait = false;
        Logger log = event.getSession().getLogger();
        try {
            log.info("Applying kubernetes configuration from: " + configuration.getConfigUrl());
            Object dto = KubernetesHelper.loadJson((String)Util.readAsString(configuration.getConfigUrl()));
            if (dto instanceof Config) {
                for (Object entity : KubernetesHelper.getEntities((Config)((Config)dto))) {
                    if (entity instanceof Pod) {
                        Pod pod = (Pod)entity;
                        if (pod.getLabels() == null) {
                            pod.setLabels(new HashMap());
                        }
                        pod.getLabels().put("arquillian", event.getSession().getId());
                        controller.applyPod(pod, event.getSession().getId());
                        shouldWait = true;
                        continue;
                    }
                    if (entity instanceof Service) {
                        Service service = (Service)entity;
                        if (service.getLabels() == null) {
                            service.setLabels(new HashMap());
                        }
                        service.getLabels().put("arquillian", event.getSession().getId());
                        controller.applyService(service, event.getSession().getId());
                        continue;
                    }
                    if (!(entity instanceof ReplicationController)) continue;
                    ReplicationController replicationController = (ReplicationController)entity;
                    replicationController.getDesiredState().getPodTemplate().getLabels().put("arquillian", event.getSession().getId());
                    if (replicationController.getLabels() == null) {
                        replicationController.setLabels(new HashMap());
                    }
                    replicationController.getLabels().put("arquillian", event.getSession().getId());
                    controller.applyReplicationController(replicationController, event.getSession().getId());
                    shouldWait = true;
                }
            }
            if (shouldWait) {
                SessionPodsAreReady sessionPodsReady = new SessionPodsAreReady(client, event.getSession());
                WaitStrategy waitStrategy = new WaitStrategy(sessionPodsReady, configuration.getTimeout(), configuration.getPollInterval());
                if (!waitStrategy.await()) {
                    log.error("Timed out waiting for pods!");
                } else {
                    log.status("All pods are currently 'running'!");
                }
            } else {
                log.warn("No pods/replication controllers defined in the configuration!");
            }
            Util.displaySessionStatus(client, event.getSession());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop(@Observes Stop event, KubernetesClient client) throws Exception {
        Util.cleanupSession(client, event.getSession());
    }
}

