/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.await;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.utils.Util;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.PodStatus;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.utils.Filter;
import io.fabric8.utils.Objects;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;

public class SessionPodsAreReady
implements Callable<Boolean> {
    private Session session;
    private KubernetesClient kubernetesClient;

    public SessionPodsAreReady(KubernetesClient kubernetesClient, Session session) {
        this.session = session;
        this.kubernetesClient = kubernetesClient;
    }

    @Override
    public Boolean call() throws Exception {
        boolean result = true;
        Map<String, String> labels = Collections.singletonMap("arquillian", this.session.getId());
        Filter podFilter = KubernetesHelper.createPodFilter(labels);
        List<Pod> pods = Util.findPods(this.kubernetesClient, (Filter<Pod>)podFilter);
        if (pods.isEmpty()) {
            result = false;
            this.session.getLogger().warn("No pods are available yet, waiting...");
        }
        for (Pod pod : pods) {
            if (result = result && Objects.equal((Object)PodStatus.OK, (Object)KubernetesHelper.getPodStatus((Pod)pod))) continue;
            this.session.getLogger().warn("Waiting for pods to reach 'running' state...");
        }
        return result;
    }
}

