/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.kubernetes.enricher;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.utils.Filter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.arquillian.test.spi.enricher.resource.ResourceProvider;

public class ReplicationControllerListResourceProvider
implements ResourceProvider {
    @Inject
    private Instance<KubernetesClient> clientInstance;
    @Inject
    private Instance<Session> sessionInstance;

    public boolean canProvide(Class<?> type) {
        return ReplicationControllerList.class.isAssignableFrom(type);
    }

    public Object lookup(ArquillianResource resource, Annotation ... qualifiers) {
        KubernetesClient client = (KubernetesClient)this.clientInstance.get();
        Session session = (Session)this.sessionInstance.get();
        Map<String, String> labels = Collections.singletonMap("arquillian", session.getId());
        Filter replicationControllerFilter = KubernetesHelper.createReplicationControllerFilter(labels);
        ReplicationControllerList controllers = client.getReplicationControllers();
        ArrayList<ReplicationController> sessionControllers = new ArrayList<ReplicationController>();
        for (ReplicationController pod : client.getReplicationControllers().getItems()) {
            if (!replicationControllerFilter.matches((Object)pod)) continue;
            sessionControllers.add(pod);
        }
        controllers.setItems(sessionControllers);
        return controllers;
    }
}

