/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.arquillian.utils;

import io.fabric8.arquillian.kubernetes.Session;
import io.fabric8.arquillian.kubernetes.log.Logger;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.utils.Filter;
import io.fabric8.utils.MultiException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Util {
    public static String readAsString(URL url) {
        StringBuilder response = new StringBuilder();
        try (InputStreamReader isr = new InputStreamReader(url.openStream());
             BufferedReader br = new BufferedReader(isr);){
            String line;
            while ((line = br.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return response.toString();
    }

    public static void displaySessionStatus(KubernetesClient client, Session session) throws MultiException {
        Map<String, String> labels = Collections.singletonMap("arquillian", session.getId());
        Filter podFilter = KubernetesHelper.createPodFilter(labels);
        Filter serviceFilter = KubernetesHelper.createServiceFilter(labels);
        Filter replicationControllerFilter = KubernetesHelper.createReplicationControllerFilter(labels);
        for (ReplicationController replicationController : client.getReplicationControllers().getItems()) {
            if (!replicationControllerFilter.matches((Object)replicationController)) continue;
            session.getLogger().info("Replication controller:" + KubernetesHelper.getId((ReplicationController)replicationController));
        }
        for (Pod pod : client.getPods().getItems()) {
            if (!podFilter.matches((Object)pod)) continue;
            session.getLogger().info("Pod:" + KubernetesHelper.getId((Pod)pod) + " Status:" + pod.getCurrentState().getStatus());
        }
        for (Service service : client.getServices().getItems()) {
            if (!serviceFilter.matches((Object)service)) continue;
            session.getLogger().info("Service:" + KubernetesHelper.getId((Service)service) + " IP:" + KubernetesHelper.getPortalIP((Service)service) + " Port:" + KubernetesHelper.getPort((Service)service));
        }
    }

    public static void cleanupSession(KubernetesClient client, Session session) throws MultiException {
        Map<String, String> labels = Collections.singletonMap("arquillian", session.getId());
        Filter podFilter = KubernetesHelper.createPodFilter(labels);
        Filter serviceFilter = KubernetesHelper.createServiceFilter(labels);
        Filter replicationControllerFilter = KubernetesHelper.createReplicationControllerFilter(labels);
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            Util.deleteReplicationControllers(client, session.getLogger(), (Filter<ReplicationController>)replicationControllerFilter);
        }
        catch (MultiException e) {
            errors.addAll(Arrays.asList(e.getCauses()));
        }
        try {
            Util.deletePods(client, session.getLogger(), (Filter<Pod>)podFilter);
        }
        catch (MultiException e) {
            errors.addAll(Arrays.asList(e.getCauses()));
        }
        try {
            Util.deleteServices(client, session.getLogger(), (Filter<Service>)serviceFilter);
        }
        catch (MultiException e) {
            errors.addAll(Arrays.asList(e.getCauses()));
        }
        if (!errors.isEmpty()) {
            throw new MultiException("Error while cleaning up session.", errors);
        }
    }

    public static List<Pod> findPods(KubernetesClient client, Filter<Pod> filter) throws MultiException {
        ArrayList<Pod> pods = new ArrayList<Pod>();
        for (Pod pod : client.getPods().getItems()) {
            if (!filter.matches((Object)pod)) continue;
            pods.add(pod);
        }
        return pods;
    }

    public static void deletePods(KubernetesClient client, Logger logger, Filter<Pod> filter) throws MultiException {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        for (Pod pod : client.getPods().getItems()) {
            if (!filter.matches((Object)pod)) continue;
            try {
                logger.info("Deleting pod:" + KubernetesHelper.getId((Pod)pod));
                client.deletePod(KubernetesHelper.getId((Pod)pod));
            }
            catch (Exception e) {
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            throw new MultiException("Error while deleting pods", errors);
        }
    }

    public static List<Service> findServices(KubernetesClient client, Filter<Service> filter) throws MultiException {
        ArrayList<Service> services = new ArrayList<Service>();
        for (Service service : client.getServices().getItems()) {
            if (!filter.matches((Object)service)) continue;
            services.add(service);
        }
        return services;
    }

    public static void deleteServices(KubernetesClient client, Logger logger, Filter<Service> filter) throws MultiException {
        ArrayList errors = new ArrayList();
        for (Service service : client.getServices().getItems()) {
            if (!filter.matches((Object)service)) continue;
            try {
                logger.info("Deleting service:" + KubernetesHelper.getId((Service)service));
                client.deleteService(KubernetesHelper.getId((Service)service));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!errors.isEmpty()) {
            throw new MultiException("Error while deleting services", errors);
        }
    }

    public static List<ReplicationController> findReplicationControllers(KubernetesClient client, Filter<ReplicationController> filter) throws MultiException {
        ArrayList<ReplicationController> replicationControllers = new ArrayList<ReplicationController>();
        for (ReplicationController replicationController : client.getReplicationControllers().getItems()) {
            if (!filter.matches((Object)replicationController)) continue;
            replicationControllers.add(replicationController);
        }
        return replicationControllers;
    }

    public static void deleteReplicationControllers(KubernetesClient client, Logger logger, Filter<ReplicationController> filter) throws MultiException {
        ArrayList errors = new ArrayList();
        for (ReplicationController replicationController : client.getReplicationControllers().getItems()) {
            if (!filter.matches((Object)replicationController)) continue;
            try {
                logger.info("Deleting replication controller:" + KubernetesHelper.getId((ReplicationController)replicationController));
                client.deleteReplicationController(KubernetesHelper.getId((ReplicationController)replicationController));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!errors.isEmpty()) {
            throw new MultiException("Error while deleting replication controllers", errors);
        }
    }
}

