/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.mock;

import io.fabric8.camelk.client.CamelKClient;
import io.fabric8.camelk.client.NamespacedCamelKClient;
import io.fabric8.camelk.mock.CamelKMockServer;
import io.fabric8.camelk.mock.EnableCamelKMockClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesCrudDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class CamelKMockServerExtension
extends KubernetesMockServerExtension {
    private CamelKMockServer camelKMockServer;
    private NamespacedCamelKClient camelKClient;

    protected void destroy() {
        this.camelKMockServer.destroy();
        this.camelKClient.close();
    }

    protected Class<?> getClientType() {
        return CamelKClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return CamelKMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableCamelKMockClient a = testClass.getAnnotation(EnableCamelKMockClient.class);
        this.camelKMockServer = a.crud() ? new CamelKMockServer(new Context(), new MockWebServer(), new HashMap<ServerRequest, Queue<ServerResponse>>(), (Dispatcher)new KubernetesCrudDispatcher(Collections.emptyList()), a.https()) : new CamelKMockServer(a.https());
        this.camelKMockServer.init();
        this.camelKClient = this.camelKMockServer.createCamelKClient();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.camelKClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.camelKMockServer));
    }
}

