/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.camelk.v1;

import io.fabric8.camelk.v1.Artifact;
import io.fabric8.camelk.v1.ArtifactFluent;
import io.fabric8.camelk.v1.ArtifactFluentImpl;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.Objects;

public class ArtifactBuilder
extends ArtifactFluentImpl<ArtifactBuilder>
implements VisitableBuilder<Artifact, ArtifactBuilder> {
    ArtifactFluent<?> fluent;
    Boolean validationEnabled;

    public ArtifactBuilder() {
        this(false);
    }

    public ArtifactBuilder(Boolean validationEnabled) {
        this(new Artifact(), validationEnabled);
    }

    public ArtifactBuilder(ArtifactFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public ArtifactBuilder(ArtifactFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new Artifact(), validationEnabled);
    }

    public ArtifactBuilder(ArtifactFluent<?> fluent, Artifact instance) {
        this(fluent, instance, false);
    }

    public ArtifactBuilder(ArtifactFluent<?> fluent, Artifact instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withChecksum(instance.getChecksum());
        fluent.withId(instance.getId());
        fluent.withLocation(instance.getLocation());
        fluent.withTarget(instance.getTarget());
        this.validationEnabled = validationEnabled;
    }

    public ArtifactBuilder(Artifact instance) {
        this(instance, (Boolean)false);
    }

    public ArtifactBuilder(Artifact instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withChecksum(instance.getChecksum());
        this.withId(instance.getId());
        this.withLocation(instance.getLocation());
        this.withTarget(instance.getTarget());
        this.validationEnabled = validationEnabled;
    }

    public Artifact build() {
        Artifact buildable = new Artifact(this.fluent.getChecksum(), this.fluent.getId(), this.fluent.getLocation(), this.fluent.getTarget());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArtifactBuilder that = (ArtifactBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

