package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.VolumeBuilder;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Duration;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import io.fabric8.kubernetes.api.model.Volume;
import io.fabric8.kubernetes.api.model.Affinity;
import io.fabric8.kubernetes.api.model.VolumeMount;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.VolumeMountFluentImpl;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.VolumeFluentImpl;
import java.util.Iterator;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.StringBuffer;

public class BuilderTaskFluentImpl<A extends BuilderTaskFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BuilderTaskFluent<A> {

    private Affinity affinity;
    private String baseImage;
    private String buildDir;
    private List<String> dependencies;
    private String image;
    private MavenSpecBuilder maven;
    private ObjectMetaBuilder meta;
    private String name;
    private java.util.Map<String,String> properties;
    private List<ResourceSpecBuilder> resources;
    private RuntimeSpecBuilder runtime;
    private List<SourceSpecBuilder> sources;
    private List<String> steps;
    private Duration timeout;
    private List<VolumeMountBuilder> volumeMounts;
    private List<VolumeBuilder> volumes;

    public BuilderTaskFluentImpl() {
    }

    public BuilderTaskFluentImpl(BuilderTask instance) {
        this.withAffinity(instance.getAffinity()); 
        this.withBaseImage(instance.getBaseImage()); 
        this.withBuildDir(instance.getBuildDir()); 
        this.withDependencies(instance.getDependencies()); 
        this.withImage(instance.getImage()); 
        this.withMaven(instance.getMaven()); 
        this.withMeta(instance.getMeta()); 
        this.withName(instance.getName()); 
        this.withProperties(instance.getProperties()); 
        this.withResources(instance.getResources()); 
        this.withRuntime(instance.getRuntime()); 
        this.withSources(instance.getSources()); 
        this.withSteps(instance.getSteps()); 
        this.withTimeout(instance.getTimeout()); 
        this.withVolumeMounts(instance.getVolumeMounts()); 
        this.withVolumes(instance.getVolumes()); 
    }

    public Affinity getAffinity() {
        return this.affinity;
    }

    public A withAffinity(Affinity affinity) {
        this.affinity=affinity; return (A) this;
    }

    public Boolean hasAffinity() {
        return this.affinity != null;
    }

    public String getBaseImage() {
        return this.baseImage;
    }

    public A withBaseImage(String baseImage) {
        this.baseImage=baseImage; return (A) this;
    }

    public Boolean hasBaseImage() {
        return this.baseImage != null;
    }

    public A withNewBaseImage(StringBuilder arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(int[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(char[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(StringBuffer arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(byte[] arg1,int arg2) {
        return (A)withBaseImage(new String(arg1, arg2));
    }

    public A withNewBaseImage(byte[] arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public A withNewBaseImage(char[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3) {
        return (A)withBaseImage(new String(arg1, arg2, arg3));
    }

    public A withNewBaseImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBaseImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBaseImage(String arg1) {
        return (A)withBaseImage(new String(arg1));
    }

    public String getBuildDir() {
        return this.buildDir;
    }

    public A withBuildDir(String buildDir) {
        this.buildDir=buildDir; return (A) this;
    }

    public Boolean hasBuildDir() {
        return this.buildDir != null;
    }

    public A withNewBuildDir(StringBuilder arg1) {
        return (A)withBuildDir(new String(arg1));
    }

    public A withNewBuildDir(int[] arg1,int arg2,int arg3) {
        return (A)withBuildDir(new String(arg1, arg2, arg3));
    }

    public A withNewBuildDir(char[] arg1) {
        return (A)withBuildDir(new String(arg1));
    }

    public A withNewBuildDir(StringBuffer arg1) {
        return (A)withBuildDir(new String(arg1));
    }

    public A withNewBuildDir(byte[] arg1,int arg2) {
        return (A)withBuildDir(new String(arg1, arg2));
    }

    public A withNewBuildDir(byte[] arg1) {
        return (A)withBuildDir(new String(arg1));
    }

    public A withNewBuildDir(char[] arg1,int arg2,int arg3) {
        return (A)withBuildDir(new String(arg1, arg2, arg3));
    }

    public A withNewBuildDir(byte[] arg1,int arg2,int arg3) {
        return (A)withBuildDir(new String(arg1, arg2, arg3));
    }

    public A withNewBuildDir(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withBuildDir(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewBuildDir(String arg1) {
        return (A)withBuildDir(new String(arg1));
    }

    public A addToDependencies(int index,String item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        this.dependencies.add(index, item);
        return (A)this;
    }

    public A setToDependencies(int index,String item) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        this.dependencies.set(index, item); return (A)this;
    }

    public A addToDependencies(String... items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        for (String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {this.dependencies = new ArrayList<String>();}
        for (String item : items) {this.dependencies.add(item);} return (A)this;
    }

    public A removeFromDependencies(String... items) {
        for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public A removeAllFromDependencies(Collection<String> items) {
        for (String item : items) {if (this.dependencies!= null){ this.dependencies.remove(item);}} return (A)this;
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public String getLastDependency() {
        return this.dependencies.get(dependencies.size() - 1);
    }

    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item: dependencies) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item: dependencies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withDependencies(List<String> dependencies) {
        if (this.dependencies != null) { _visitables.get("dependencies").removeAll(this.dependencies);}
        if (dependencies != null) {this.dependencies = new ArrayList<String>(); for (String item : dependencies){this.addToDependencies(item);}} else { this.dependencies = null;} return (A) this;
    }

    public A withDependencies(String... dependencies) {
        if (this.dependencies != null) {this.dependencies.clear();}
        if (dependencies != null) {for (String item :dependencies){ this.addToDependencies(item);}} return (A) this;
    }

    public Boolean hasDependencies() {
        return dependencies != null && !dependencies.isEmpty();
    }

    public A addNewDependency(StringBuilder arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(int[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(char[] arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(StringBuffer arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(byte[] arg1,int arg2) {
        return (A)addToDependencies(new String(arg1, arg2));
    }

    public A addNewDependency(byte[] arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public A addNewDependency(char[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(byte[] arg1,int arg2,int arg3) {
        return (A)addToDependencies(new String(arg1, arg2, arg3));
    }

    public A addNewDependency(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToDependencies(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewDependency(String arg1) {
        return (A)addToDependencies(new String(arg1));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image=image; return (A) this;
    }

    public Boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(StringBuilder arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(int[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(char[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(StringBuffer arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(byte[] arg1,int arg2) {
        return (A)withImage(new String(arg1, arg2));
    }

    public A withNewImage(byte[] arg1) {
        return (A)withImage(new String(arg1));
    }

    public A withNewImage(char[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3) {
        return (A)withImage(new String(arg1, arg2, arg3));
    }

    public A withNewImage(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withImage(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewImage(String arg1) {
        return (A)withImage(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMaven instead.
 * @return The buildable object.
 */
@Deprecated public MavenSpec getMaven() {
        return this.maven!=null?this.maven.build():null;
    }

    public MavenSpec buildMaven() {
        return this.maven!=null?this.maven.build():null;
    }

    public A withMaven(MavenSpec maven) {
        _visitables.get("maven").remove(this.maven);
        if (maven!=null){ this.maven= new MavenSpecBuilder(maven); _visitables.get("maven").add(this.maven);} return (A) this;
    }

    public Boolean hasMaven() {
        return this.maven != null;
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> withNewMaven() {
        return new MavenNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> withNewMavenLike(MavenSpec item) {
        return new MavenNestedImpl(item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editMaven() {
        return withNewMavenLike(getMaven());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editOrNewMaven() {
        return withNewMavenLike(getMaven() != null ? getMaven(): new MavenSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<A> editOrNewMavenLike(MavenSpec item) {
        return withNewMavenLike(getMaven() != null ? getMaven(): item);
    }

    
/**
 * This method has been deprecated, please use method buildMeta instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMeta() {
        return this.meta!=null?this.meta.build():null;
    }

    public ObjectMeta buildMeta() {
        return this.meta!=null?this.meta.build():null;
    }

    public A withMeta(ObjectMeta meta) {
        _visitables.get("meta").remove(this.meta);
        if (meta!=null){ this.meta= new ObjectMetaBuilder(meta); _visitables.get("meta").add(this.meta);} return (A) this;
    }

    public Boolean hasMeta() {
        return this.meta != null;
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> withNewMeta() {
        return new MetaNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> withNewMetaLike(ObjectMeta item) {
        return new MetaNestedImpl(item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> editMeta() {
        return withNewMetaLike(getMeta());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> editOrNewMeta() {
        return withNewMetaLike(getMeta() != null ? getMeta(): new ObjectMetaBuilder().build());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<A> editOrNewMetaLike(ObjectMeta item) {
        return withNewMetaLike(getMeta() != null ? getMeta(): item);
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(int[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(char[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(byte[] arg1,int arg2) {
        return (A)withName(new String(arg1, arg2));
    }

    public A withNewName(byte[] arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(char[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3) {
        return (A)withName(new String(arg1, arg2, arg3));
    }

    public A withNewName(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withName(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A addToProperties(String key,String value) {
        if(this.properties == null && key != null && value != null) { this.properties = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.properties.put(key, value);} return (A)this;
    }

    public A addToProperties(java.util.Map<String,String> map) {
        if(this.properties == null && map != null) { this.properties = new LinkedHashMap<String,String>(); }
        if(map != null) { this.properties.putAll(map);} return (A)this;
    }

    public A removeFromProperties(String key) {
        if(this.properties == null) { return (A) this; }
        if(key != null && this.properties != null) {this.properties.remove(key);} return (A)this;
    }

    public A removeFromProperties(java.util.Map<String,String> map) {
        if(this.properties == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.properties != null){this.properties.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getProperties() {
        return this.properties;
    }

    public <K extends Object,V extends Object>A withProperties(java.util.Map<String,String> properties) {
        if (properties == null) { this.properties =  null;} else {this.properties = new LinkedHashMap<String,String>(properties);} return (A) this;
    }

    public Boolean hasProperties() {
        return this.properties != null;
    }

    public A addToResources(int index,ResourceSpec item) {
        if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(index >= 0 ? index : _visitables.get("resources").size(), builder);this.resources.add(index >= 0 ? index : resources.size(), builder); return (A)this;
    }

    public A setToResources(int index,ResourceSpec item) {
        if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
        ResourceSpecBuilder builder = new ResourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("resources").size()) { _visitables.get("resources").add(builder); } else { _visitables.get("resources").set(index, builder);}
        if (index < 0 || index >= resources.size()) { resources.add(builder); } else { resources.set(index, builder);}
         return (A)this;
    }

    public A addToResources(ResourceSpec... items) {
        if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A addAllToResources(Collection<ResourceSpec> items) {
        if (this.resources == null) {this.resources = new ArrayList<ResourceSpecBuilder>();}
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").add(builder);this.resources.add(builder);} return (A)this;
    }

    public A removeFromResources(ResourceSpec... items) {
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeAllFromResources(Collection<ResourceSpec> items) {
        for (ResourceSpec item : items) {ResourceSpecBuilder builder = new ResourceSpecBuilder(item);_visitables.get("resources").remove(builder);if (this.resources != null) {this.resources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromResources(Predicate<ResourceSpecBuilder> predicate) {
        if (resources == null) return (A) this;
        final Iterator<ResourceSpecBuilder> each = resources.iterator();
        final List visitables = _visitables.get("resources");
        while (each.hasNext()) {
          ResourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildResources instead.
 * @return The buildable object.
 */
@Deprecated public List<ResourceSpec> getResources() {
        return build(resources);
    }

    public List<ResourceSpec> buildResources() {
        return build(resources);
    }

    public ResourceSpec buildResource(int index) {
        return this.resources.get(index).build();
    }

    public ResourceSpec buildFirstResource() {
        return this.resources.get(0).build();
    }

    public ResourceSpec buildLastResource() {
        return this.resources.get(resources.size() - 1).build();
    }

    public ResourceSpec buildMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        for (ResourceSpecBuilder item: resources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withResources(List<ResourceSpec> resources) {
        if (this.resources != null) { _visitables.get("resources").removeAll(this.resources);}
        if (resources != null) {this.resources = new ArrayList<ResourceSpecBuilder>(); for (ResourceSpec item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
    }

    public A withResources(ResourceSpec... resources) {
        if (this.resources != null) {this.resources.clear();}
        if (resources != null) {for (ResourceSpec item :resources){ this.addToResources(item);}} return (A) this;
    }

    public Boolean hasResources() {
        return resources != null && !resources.isEmpty();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> addNewResource() {
        return new ResourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> addNewResourceLike(ResourceSpec item) {
        return new ResourcesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> setNewResourceLike(int index,ResourceSpec item) {
        return new ResourcesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editResource(int index) {
        if (resources.size() <= index) throw new RuntimeException("Can't edit resources. Index exceeds size.");
        return setNewResourceLike(index, buildResource(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editFirstResource() {
        if (resources.size() == 0) throw new RuntimeException("Can't edit first resources. The list is empty.");
        return setNewResourceLike(0, buildResource(0));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editLastResource() {
        int index = resources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last resources. The list is empty.");
        return setNewResourceLike(index, buildResource(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<A> editMatchingResource(Predicate<ResourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<resources.size();i++) { 
        if (predicate.test(resources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching resources. No match found.");
        return setNewResourceLike(index, buildResource(index));
    }

    
/**
 * This method has been deprecated, please use method buildRuntime instead.
 * @return The buildable object.
 */
@Deprecated public RuntimeSpec getRuntime() {
        return this.runtime!=null?this.runtime.build():null;
    }

    public RuntimeSpec buildRuntime() {
        return this.runtime!=null?this.runtime.build():null;
    }

    public A withRuntime(RuntimeSpec runtime) {
        _visitables.get("runtime").remove(this.runtime);
        if (runtime!=null){ this.runtime= new RuntimeSpecBuilder(runtime); _visitables.get("runtime").add(this.runtime);} return (A) this;
    }

    public Boolean hasRuntime() {
        return this.runtime != null;
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> withNewRuntime() {
        return new RuntimeNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> withNewRuntimeLike(RuntimeSpec item) {
        return new RuntimeNestedImpl(item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editRuntime() {
        return withNewRuntimeLike(getRuntime());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editOrNewRuntime() {
        return withNewRuntimeLike(getRuntime() != null ? getRuntime(): new RuntimeSpecBuilder().build());
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<A> editOrNewRuntimeLike(RuntimeSpec item) {
        return withNewRuntimeLike(getRuntime() != null ? getRuntime(): item);
    }

    public A addToSources(int index,SourceSpec item) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
        SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(index >= 0 ? index : _visitables.get("sources").size(), builder);this.sources.add(index >= 0 ? index : sources.size(), builder); return (A)this;
    }

    public A setToSources(int index,SourceSpec item) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
        SourceSpecBuilder builder = new SourceSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("sources").size()) { _visitables.get("sources").add(builder); } else { _visitables.get("sources").set(index, builder);}
        if (index < 0 || index >= sources.size()) { sources.add(builder); } else { sources.set(index, builder);}
         return (A)this;
    }

    public A addToSources(SourceSpec... items) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A addAllToSources(Collection<SourceSpec> items) {
        if (this.sources == null) {this.sources = new ArrayList<SourceSpecBuilder>();}
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").add(builder);this.sources.add(builder);} return (A)this;
    }

    public A removeFromSources(SourceSpec... items) {
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeAllFromSources(Collection<SourceSpec> items) {
        for (SourceSpec item : items) {SourceSpecBuilder builder = new SourceSpecBuilder(item);_visitables.get("sources").remove(builder);if (this.sources != null) {this.sources.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromSources(Predicate<SourceSpecBuilder> predicate) {
        if (sources == null) return (A) this;
        final Iterator<SourceSpecBuilder> each = sources.iterator();
        final List visitables = _visitables.get("sources");
        while (each.hasNext()) {
          SourceSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildSources instead.
 * @return The buildable object.
 */
@Deprecated public List<SourceSpec> getSources() {
        return build(sources);
    }

    public List<SourceSpec> buildSources() {
        return build(sources);
    }

    public SourceSpec buildSource(int index) {
        return this.sources.get(index).build();
    }

    public SourceSpec buildFirstSource() {
        return this.sources.get(0).build();
    }

    public SourceSpec buildLastSource() {
        return this.sources.get(sources.size() - 1).build();
    }

    public SourceSpec buildMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item: sources) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        for (SourceSpecBuilder item: sources) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSources(List<SourceSpec> sources) {
        if (this.sources != null) { _visitables.get("sources").removeAll(this.sources);}
        if (sources != null) {this.sources = new ArrayList<SourceSpecBuilder>(); for (SourceSpec item : sources){this.addToSources(item);}} else { this.sources = null;} return (A) this;
    }

    public A withSources(SourceSpec... sources) {
        if (this.sources != null) {this.sources.clear();}
        if (sources != null) {for (SourceSpec item :sources){ this.addToSources(item);}} return (A) this;
    }

    public Boolean hasSources() {
        return sources != null && !sources.isEmpty();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> addNewSource() {
        return new SourcesNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> addNewSourceLike(SourceSpec item) {
        return new SourcesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> setNewSourceLike(int index,SourceSpec item) {
        return new SourcesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editSource(int index) {
        if (sources.size() <= index) throw new RuntimeException("Can't edit sources. Index exceeds size.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editFirstSource() {
        if (sources.size() == 0) throw new RuntimeException("Can't edit first sources. The list is empty.");
        return setNewSourceLike(0, buildSource(0));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editLastSource() {
        int index = sources.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last sources. The list is empty.");
        return setNewSourceLike(index, buildSource(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<A> editMatchingSource(Predicate<SourceSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<sources.size();i++) { 
        if (predicate.test(sources.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching sources. No match found.");
        return setNewSourceLike(index, buildSource(index));
    }

    public A addToSteps(int index,String item) {
        if (this.steps == null) {this.steps = new ArrayList<String>();}
        this.steps.add(index, item);
        return (A)this;
    }

    public A setToSteps(int index,String item) {
        if (this.steps == null) {this.steps = new ArrayList<String>();}
        this.steps.set(index, item); return (A)this;
    }

    public A addToSteps(String... items) {
        if (this.steps == null) {this.steps = new ArrayList<String>();}
        for (String item : items) {this.steps.add(item);} return (A)this;
    }

    public A addAllToSteps(Collection<String> items) {
        if (this.steps == null) {this.steps = new ArrayList<String>();}
        for (String item : items) {this.steps.add(item);} return (A)this;
    }

    public A removeFromSteps(String... items) {
        for (String item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
    }

    public A removeAllFromSteps(Collection<String> items) {
        for (String item : items) {if (this.steps!= null){ this.steps.remove(item);}} return (A)this;
    }

    public List<String> getSteps() {
        return this.steps;
    }

    public String getStep(int index) {
        return this.steps.get(index);
    }

    public String getFirstStep() {
        return this.steps.get(0);
    }

    public String getLastStep() {
        return this.steps.get(steps.size() - 1);
    }

    public String getMatchingStep(Predicate<String> predicate) {
        for (String item: steps) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingStep(Predicate<String> predicate) {
        for (String item: steps) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withSteps(List<String> steps) {
        if (this.steps != null) { _visitables.get("steps").removeAll(this.steps);}
        if (steps != null) {this.steps = new ArrayList<String>(); for (String item : steps){this.addToSteps(item);}} else { this.steps = null;} return (A) this;
    }

    public A withSteps(String... steps) {
        if (this.steps != null) {this.steps.clear();}
        if (steps != null) {for (String item :steps){ this.addToSteps(item);}} return (A) this;
    }

    public Boolean hasSteps() {
        return steps != null && !steps.isEmpty();
    }

    public A addNewStep(StringBuilder arg1) {
        return (A)addToSteps(new String(arg1));
    }

    public A addNewStep(int[] arg1,int arg2,int arg3) {
        return (A)addToSteps(new String(arg1, arg2, arg3));
    }

    public A addNewStep(char[] arg1) {
        return (A)addToSteps(new String(arg1));
    }

    public A addNewStep(StringBuffer arg1) {
        return (A)addToSteps(new String(arg1));
    }

    public A addNewStep(byte[] arg1,int arg2) {
        return (A)addToSteps(new String(arg1, arg2));
    }

    public A addNewStep(byte[] arg1) {
        return (A)addToSteps(new String(arg1));
    }

    public A addNewStep(char[] arg1,int arg2,int arg3) {
        return (A)addToSteps(new String(arg1, arg2, arg3));
    }

    public A addNewStep(byte[] arg1,int arg2,int arg3) {
        return (A)addToSteps(new String(arg1, arg2, arg3));
    }

    public A addNewStep(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToSteps(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewStep(String arg1) {
        return (A)addToSteps(new String(arg1));
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public A withTimeout(Duration timeout) {
        this.timeout=timeout; return (A) this;
    }

    public Boolean hasTimeout() {
        return this.timeout != null;
    }

    public A addToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
        VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(index >= 0 ? index : _visitables.get("volumeMounts").size(), builder);this.volumeMounts.add(index >= 0 ? index : volumeMounts.size(), builder); return (A)this;
    }

    public A setToVolumeMounts(int index,VolumeMount item) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
        VolumeMountBuilder builder = new VolumeMountBuilder(item);
        if (index < 0 || index >= _visitables.get("volumeMounts").size()) { _visitables.get("volumeMounts").add(builder); } else { _visitables.get("volumeMounts").set(index, builder);}
        if (index < 0 || index >= volumeMounts.size()) { volumeMounts.add(builder); } else { volumeMounts.set(index, builder);}
         return (A)this;
    }

    public A addToVolumeMounts(VolumeMount... items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
        for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A addAllToVolumeMounts(Collection<VolumeMount> items) {
        if (this.volumeMounts == null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>();}
        for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").add(builder);this.volumeMounts.add(builder);} return (A)this;
    }

    public A removeFromVolumeMounts(VolumeMount... items) {
        for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumeMounts(Collection<VolumeMount> items) {
        for (VolumeMount item : items) {VolumeMountBuilder builder = new VolumeMountBuilder(item);_visitables.get("volumeMounts").remove(builder);if (this.volumeMounts != null) {this.volumeMounts.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumeMounts(Predicate<VolumeMountBuilder> predicate) {
        if (volumeMounts == null) return (A) this;
        final Iterator<VolumeMountBuilder> each = volumeMounts.iterator();
        final List visitables = _visitables.get("volumeMounts");
        while (each.hasNext()) {
          VolumeMountBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumeMounts instead.
 * @return The buildable object.
 */
@Deprecated public List<VolumeMount> getVolumeMounts() {
        return build(volumeMounts);
    }

    public List<VolumeMount> buildVolumeMounts() {
        return build(volumeMounts);
    }

    public VolumeMount buildVolumeMount(int index) {
        return this.volumeMounts.get(index).build();
    }

    public VolumeMount buildFirstVolumeMount() {
        return this.volumeMounts.get(0).build();
    }

    public VolumeMount buildLastVolumeMount() {
        return this.volumeMounts.get(volumeMounts.size() - 1).build();
    }

    public VolumeMount buildMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        for (VolumeMountBuilder item: volumeMounts) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumeMounts(List<VolumeMount> volumeMounts) {
        if (this.volumeMounts != null) { _visitables.get("volumeMounts").removeAll(this.volumeMounts);}
        if (volumeMounts != null) {this.volumeMounts = new ArrayList<VolumeMountBuilder>(); for (VolumeMount item : volumeMounts){this.addToVolumeMounts(item);}} else { this.volumeMounts = null;} return (A) this;
    }

    public A withVolumeMounts(VolumeMount... volumeMounts) {
        if (this.volumeMounts != null) {this.volumeMounts.clear();}
        if (volumeMounts != null) {for (VolumeMount item :volumeMounts){ this.addToVolumeMounts(item);}} return (A) this;
    }

    public Boolean hasVolumeMounts() {
        return volumeMounts != null && !volumeMounts.isEmpty();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> addNewVolumeMount() {
        return new VolumeMountsNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> addNewVolumeMountLike(VolumeMount item) {
        return new VolumeMountsNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> setNewVolumeMountLike(int index,VolumeMount item) {
        return new VolumeMountsNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editVolumeMount(int index) {
        if (volumeMounts.size() <= index) throw new RuntimeException("Can't edit volumeMounts. Index exceeds size.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editFirstVolumeMount() {
        if (volumeMounts.size() == 0) throw new RuntimeException("Can't edit first volumeMounts. The list is empty.");
        return setNewVolumeMountLike(0, buildVolumeMount(0));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editLastVolumeMount() {
        int index = volumeMounts.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumeMounts. The list is empty.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<A> editMatchingVolumeMount(Predicate<VolumeMountBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumeMounts.size();i++) { 
        if (predicate.test(volumeMounts.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumeMounts. No match found.");
        return setNewVolumeMountLike(index, buildVolumeMount(index));
    }

    public A addToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(index >= 0 ? index : _visitables.get("volumes").size(), builder);this.volumes.add(index >= 0 ? index : volumes.size(), builder); return (A)this;
    }

    public A setToVolumes(int index,Volume item) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        VolumeBuilder builder = new VolumeBuilder(item);
        if (index < 0 || index >= _visitables.get("volumes").size()) { _visitables.get("volumes").add(builder); } else { _visitables.get("volumes").set(index, builder);}
        if (index < 0 || index >= volumes.size()) { volumes.add(builder); } else { volumes.set(index, builder);}
         return (A)this;
    }

    public A addToVolumes(Volume... items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A addAllToVolumes(Collection<Volume> items) {
        if (this.volumes == null) {this.volumes = new ArrayList<VolumeBuilder>();}
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").add(builder);this.volumes.add(builder);} return (A)this;
    }

    public A removeFromVolumes(Volume... items) {
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeAllFromVolumes(Collection<Volume> items) {
        for (Volume item : items) {VolumeBuilder builder = new VolumeBuilder(item);_visitables.get("volumes").remove(builder);if (this.volumes != null) {this.volumes.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromVolumes(Predicate<VolumeBuilder> predicate) {
        if (volumes == null) return (A) this;
        final Iterator<VolumeBuilder> each = volumes.iterator();
        final List visitables = _visitables.get("volumes");
        while (each.hasNext()) {
          VolumeBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildVolumes instead.
 * @return The buildable object.
 */
@Deprecated public List<Volume> getVolumes() {
        return build(volumes);
    }

    public List<Volume> buildVolumes() {
        return build(volumes);
    }

    public Volume buildVolume(int index) {
        return this.volumes.get(index).build();
    }

    public Volume buildFirstVolume() {
        return this.volumes.get(0).build();
    }

    public Volume buildLastVolume() {
        return this.volumes.get(volumes.size() - 1).build();
    }

    public Volume buildMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingVolume(Predicate<VolumeBuilder> predicate) {
        for (VolumeBuilder item: volumes) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withVolumes(List<Volume> volumes) {
        if (this.volumes != null) { _visitables.get("volumes").removeAll(this.volumes);}
        if (volumes != null) {this.volumes = new ArrayList<VolumeBuilder>(); for (Volume item : volumes){this.addToVolumes(item);}} else { this.volumes = null;} return (A) this;
    }

    public A withVolumes(Volume... volumes) {
        if (this.volumes != null) {this.volumes.clear();}
        if (volumes != null) {for (Volume item :volumes){ this.addToVolumes(item);}} return (A) this;
    }

    public Boolean hasVolumes() {
        return volumes != null && !volumes.isEmpty();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> addNewVolume() {
        return new VolumesNestedImpl();
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> addNewVolumeLike(Volume item) {
        return new VolumesNestedImpl(-1, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> setNewVolumeLike(int index,Volume item) {
        return new VolumesNestedImpl(index, item);
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editVolume(int index) {
        if (volumes.size() <= index) throw new RuntimeException("Can't edit volumes. Index exceeds size.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editFirstVolume() {
        if (volumes.size() == 0) throw new RuntimeException("Can't edit first volumes. The list is empty.");
        return setNewVolumeLike(0, buildVolume(0));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editLastVolume() {
        int index = volumes.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last volumes. The list is empty.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<A> editMatchingVolume(Predicate<VolumeBuilder> predicate) {
        int index = -1;
        for (int i=0;i<volumes.size();i++) { 
        if (predicate.test(volumes.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching volumes. No match found.");
        return setNewVolumeLike(index, buildVolume(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        BuilderTaskFluentImpl that = (BuilderTaskFluentImpl) o;
        if (affinity != null ? !affinity.equals(that.affinity) :that.affinity != null) return false;
        if (baseImage != null ? !baseImage.equals(that.baseImage) :that.baseImage != null) return false;
        if (buildDir != null ? !buildDir.equals(that.buildDir) :that.buildDir != null) return false;
        if (dependencies != null ? !dependencies.equals(that.dependencies) :that.dependencies != null) return false;
        if (image != null ? !image.equals(that.image) :that.image != null) return false;
        if (maven != null ? !maven.equals(that.maven) :that.maven != null) return false;
        if (meta != null ? !meta.equals(that.meta) :that.meta != null) return false;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (properties != null ? !properties.equals(that.properties) :that.properties != null) return false;
        if (resources != null ? !resources.equals(that.resources) :that.resources != null) return false;
        if (runtime != null ? !runtime.equals(that.runtime) :that.runtime != null) return false;
        if (sources != null ? !sources.equals(that.sources) :that.sources != null) return false;
        if (steps != null ? !steps.equals(that.steps) :that.steps != null) return false;
        if (timeout != null ? !timeout.equals(that.timeout) :that.timeout != null) return false;
        if (volumeMounts != null ? !volumeMounts.equals(that.volumeMounts) :that.volumeMounts != null) return false;
        if (volumes != null ? !volumes.equals(that.volumes) :that.volumes != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(affinity,  baseImage,  buildDir,  dependencies,  image,  maven,  meta,  name,  properties,  resources,  runtime,  sources,  steps,  timeout,  volumeMounts,  volumes,  super.hashCode());
    }

    public class MavenNestedImpl<N> extends MavenSpecFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.MavenNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MavenSpecBuilder builder;

            MavenNestedImpl(MavenSpec item) {
                this.builder = new MavenSpecBuilder(this, item);
                        
            }

            MavenNestedImpl() {
                this.builder = new MavenSpecBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.withMaven(builder.build());
            }

            public N endMaven() {
                return and();
            }
    }


    public class MetaNestedImpl<N> extends ObjectMetaFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.MetaNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetaNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetaNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.withMeta(builder.build());
            }

            public N endMeta() {
                return and();
            }
    }


    public class ResourcesNestedImpl<N> extends ResourceSpecFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.ResourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ResourceSpecBuilder builder;
        private final int index;

            ResourcesNestedImpl(int index,ResourceSpec item) {
                this.index = index;
                this.builder = new ResourceSpecBuilder(this, item);
                        
            }

            ResourcesNestedImpl() {
                this.index = -1;
                this.builder = new ResourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.setToResources(index,builder.build());
            }

            public N endResource() {
                return and();
            }
    }


    public class RuntimeNestedImpl<N> extends RuntimeSpecFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.RuntimeNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final RuntimeSpecBuilder builder;

            RuntimeNestedImpl(RuntimeSpec item) {
                this.builder = new RuntimeSpecBuilder(this, item);
                        
            }

            RuntimeNestedImpl() {
                this.builder = new RuntimeSpecBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.withRuntime(builder.build());
            }

            public N endRuntime() {
                return and();
            }
    }


    public class SourcesNestedImpl<N> extends SourceSpecFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.SourcesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SourceSpecBuilder builder;
        private final int index;

            SourcesNestedImpl(int index,SourceSpec item) {
                this.index = index;
                this.builder = new SourceSpecBuilder(this, item);
                        
            }

            SourcesNestedImpl() {
                this.index = -1;
                this.builder = new SourceSpecBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.setToSources(index,builder.build());
            }

            public N endSource() {
                return and();
            }
    }


    public class VolumeMountsNestedImpl<N> extends VolumeMountFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.VolumeMountsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeMountBuilder builder;
        private final int index;

            VolumeMountsNestedImpl(int index,VolumeMount item) {
                this.index = index;
                this.builder = new VolumeMountBuilder(this, item);
                        
            }

            VolumeMountsNestedImpl() {
                this.index = -1;
                this.builder = new VolumeMountBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.setToVolumeMounts(index,builder.build());
            }

            public N endVolumeMount() {
                return and();
            }
    }


    public class VolumesNestedImpl<N> extends VolumeFluentImpl<io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<N>> implements io.fabric8.camelk.v1.BuilderTaskFluent.VolumesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final VolumeBuilder builder;
        private final int index;

            VolumesNestedImpl(int index,Volume item) {
                this.index = index;
                this.builder = new VolumeBuilder(this, item);
                        
            }

            VolumesNestedImpl() {
                this.index = -1;
                this.builder = new VolumeBuilder(this);
                        
            }

            public N and() {
                return (N) BuilderTaskFluentImpl.this.setToVolumes(index,builder.build());
            }

            public N endVolume() {
                return and();
            }
    }


}
