package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformKameletSpecBuilder extends IntegrationPlatformKameletSpecFluentImpl<IntegrationPlatformKameletSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IntegrationPlatformKameletSpec,IntegrationPlatformKameletSpecBuilder> {

    IntegrationPlatformKameletSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationPlatformKameletSpecBuilder() {
        this(true);
    }

    public IntegrationPlatformKameletSpecBuilder(Boolean validationEnabled) {
        this(new IntegrationPlatformKameletSpec(), validationEnabled);
    }

    public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationPlatformKameletSpec(), validationEnabled);
    }

    public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpecFluent<?> fluent,IntegrationPlatformKameletSpec instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpecFluent<?> fluent,IntegrationPlatformKameletSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withRepositories(instance.getRepositories()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpec instance) {
        this(instance,true);
    }

    public IntegrationPlatformKameletSpecBuilder(IntegrationPlatformKameletSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withRepositories(instance.getRepositories()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatformKameletSpec build() {
        EditableIntegrationPlatformKameletSpec buildable = new EditableIntegrationPlatformKameletSpec(fluent.getRepositories());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformKameletSpecBuilder that = (IntegrationPlatformKameletSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
