package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationPlatformListBuilder extends IntegrationPlatformListFluentImpl<IntegrationPlatformListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IntegrationPlatformList,IntegrationPlatformListBuilder> {

    IntegrationPlatformListFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationPlatformListBuilder() {
        this(true);
    }

    public IntegrationPlatformListBuilder(Boolean validationEnabled) {
        this(new IntegrationPlatformList(), validationEnabled);
    }

    public IntegrationPlatformListBuilder(IntegrationPlatformListFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationPlatformListBuilder(IntegrationPlatformListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationPlatformList(), validationEnabled);
    }

    public IntegrationPlatformListBuilder(IntegrationPlatformListFluent<?> fluent,IntegrationPlatformList instance) {
        this(fluent, instance, true);
    }

    public IntegrationPlatformListBuilder(IntegrationPlatformListFluent<?> fluent,IntegrationPlatformList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationPlatformListBuilder(IntegrationPlatformList instance) {
        this(instance,true);
    }

    public IntegrationPlatformListBuilder(IntegrationPlatformList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationPlatformList build() {
        EditableIntegrationPlatformList buildable = new EditableIntegrationPlatformList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationPlatformListBuilder that = (IntegrationPlatformListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
