package io.fabric8.camelk.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IntegrationSpecBuilder extends IntegrationSpecFluentImpl<IntegrationSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<IntegrationSpec,IntegrationSpecBuilder> {

    IntegrationSpecFluent<?> fluent;
    Boolean validationEnabled;

    public IntegrationSpecBuilder() {
        this(true);
    }

    public IntegrationSpecBuilder(Boolean validationEnabled) {
        this(new IntegrationSpec(), validationEnabled);
    }

    public IntegrationSpecBuilder(IntegrationSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IntegrationSpecBuilder(IntegrationSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IntegrationSpec(), validationEnabled);
    }

    public IntegrationSpecBuilder(IntegrationSpecFluent<?> fluent,IntegrationSpec instance) {
        this(fluent, instance, true);
    }

    public IntegrationSpecBuilder(IntegrationSpecFluent<?> fluent,IntegrationSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withConfiguration(instance.getConfiguration()); 
        fluent.withDependencies(instance.getDependencies()); 
        fluent.withFlows(instance.getFlows()); 
        fluent.withKit(instance.getKit()); 
        fluent.withProfile(instance.getProfile()); 
        fluent.withReplicas(instance.getReplicas()); 
        fluent.withRepositories(instance.getRepositories()); 
        fluent.withResources(instance.getResources()); 
        fluent.withServiceAccountName(instance.getServiceAccountName()); 
        fluent.withSources(instance.getSources()); 
        fluent.withTraits(instance.getTraits()); 
        this.validationEnabled = validationEnabled; 
    }

    public IntegrationSpecBuilder(IntegrationSpec instance) {
        this(instance,true);
    }

    public IntegrationSpecBuilder(IntegrationSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withConfiguration(instance.getConfiguration()); 
        this.withDependencies(instance.getDependencies()); 
        this.withFlows(instance.getFlows()); 
        this.withKit(instance.getKit()); 
        this.withProfile(instance.getProfile()); 
        this.withReplicas(instance.getReplicas()); 
        this.withRepositories(instance.getRepositories()); 
        this.withResources(instance.getResources()); 
        this.withServiceAccountName(instance.getServiceAccountName()); 
        this.withSources(instance.getSources()); 
        this.withTraits(instance.getTraits()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.camelk.v1.EditableIntegrationSpec build() {
        EditableIntegrationSpec buildable = new EditableIntegrationSpec(fluent.getConfiguration(),fluent.getDependencies(),fluent.getFlows(),fluent.getKit(),fluent.getProfile(),fluent.getReplicas(),fluent.getRepositories(),fluent.getResources(),fluent.getServiceAccountName(),fluent.getSources(),fluent.getTraits());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IntegrationSpecBuilder that = (IntegrationSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
